/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import it.renvins.serverpulse.api.ServerPulseProvider;
import it.renvins.serverpulse.common.utils.ChatUtils;
import it.renvins.serverpulse.velocity.config.VelocityConfiguration;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class ServerPulseCommand {
    private final VelocityConfiguration config;

    public BrigadierCommand createCommand() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"serverpulsevelocity").executes(context -> {
            CommandSource source = (CommandSource)context.getSource();
            TextComponent message = LegacyComponentSerializer.legacySection().deserialize(ChatUtils.format(this.config.getConfig().getString("messages.usage")));
            source.sendMessage((Component)message);
            return 1;
        });
        command.then(((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"reload").requires(source -> source.hasPermission("serverpulse.reload"))).executes(this::executeReload));
        command.then(((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"status").requires(source -> source.hasPermission("serverpulse.status"))).executes(this::executeStatus));
        return new BrigadierCommand(command.build());
    }

    private int executeReload(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        TextComponent message = this.config.load() ? LegacyComponentSerializer.legacySection().deserialize(ChatUtils.format(this.config.getConfig().getString("messages.reloadConfig"))) : LegacyComponentSerializer.legacySection().deserialize(ChatUtils.format(this.config.getConfig().getString("messages.reloadConfigError")));
        source.sendMessage((Component)message);
        return 1;
    }

    private int executeStatus(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        TextComponent message = LegacyComponentSerializer.legacySection().deserialize(ChatUtils.format(ServerPulseProvider.get().getDatabaseService().isConnected() ? this.config.getConfig().getString("messages.statusConnected") : this.config.getConfig().getString("messages.statusNotConnected")));
        source.sendMessage((Component)message);
        return 1;
    }

    @Generated
    public ServerPulseCommand(VelocityConfiguration config) {
        this.config = config;
    }
}

