/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.simpleyaml.configuration.file.YamlFile;
import org.slf4j.Logger;

public class VelocityConfiguration {
    private final Logger logger;
    private final String name;
    private final YamlFile config;

    public VelocityConfiguration(Logger logger, Path dataDir, String name) {
        this.logger = logger;
        this.name = name;
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Failed to create data directory: " + String.valueOf(dataDir), (Throwable)e);
        }
        this.config = new YamlFile(new File(dataDir.toFile(), name));
    }

    public boolean load() {
        try {
            if (!this.config.exists()) {
                if (this.copyDefaultsFromResource()) {
                    this.logger.info("Created configuration file: " + this.name);
                } else {
                    this.config.createNewFile();
                    this.logger.info("Configuration file not found, created a new one: " + this.name);
                }
            } else {
                this.logger.info("Loading configuration file: " + this.name);
            }
            this.config.load();
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed to load configuration file: " + this.name, (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyDefaultsFromResource() {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.name);){
            if (in != null) {
                Files.copy(in, this.config.getConfigurationFile().toPath(), new CopyOption[0]);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.logger.error("Failed to copy default configuration file: " + this.name, (Throwable)e);
            return false;
        }
    }

    @Generated
    public YamlFile getConfig() {
        return this.config;
    }
}

