/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.fabric.task;

import it.renvins.serverpulse.common.scheduler.Task;
import it.renvins.serverpulse.fabric.ServerPulseFabric;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class FabricTask
implements Task {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final Runnable runnable;
    private final boolean isPeriodic;
    private final long period;
    private long ticksUntilRun;

    public FabricTask(Runnable runnable, boolean isPeriodic, long delay, long period) {
        this.runnable = runnable;
        this.isPeriodic = isPeriodic;
        this.period = period;
        this.ticksUntilRun = delay;
    }

    public void cancel() {
        this.cancelled.set(true);
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void tick() {
        if (this.cancelled.get()) {
            return;
        }
        if (--this.ticksUntilRun <= 0L) {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                ServerPulseFabric.LOGGER.log(Level.SEVERE, "An error occurred while executing task!", e);
            }
            if (this.isPeriodic && !this.cancelled.get()) {
                this.ticksUntilRun = this.period;
            } else {
                this.cancel();
            }
        }
    }
}

