/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.fabric;

import it.renvins.serverpulse.api.ServerPulseAPI;
import it.renvins.serverpulse.api.ServerPulseProvider;
import it.renvins.serverpulse.api.metrics.IDiskRetriever;
import it.renvins.serverpulse.api.metrics.IPingRetriever;
import it.renvins.serverpulse.api.metrics.ITPSRetriever;
import it.renvins.serverpulse.api.service.IDatabaseService;
import it.renvins.serverpulse.api.service.IMetricsService;
import it.renvins.serverpulse.common.DatabaseService;
import it.renvins.serverpulse.common.MetricsService;
import it.renvins.serverpulse.common.config.DatabaseConfiguration;
import it.renvins.serverpulse.common.config.MetricsConfiguration;
import it.renvins.serverpulse.common.logger.PulseLogger;
import it.renvins.serverpulse.common.metrics.DiskRetriever;
import it.renvins.serverpulse.common.platform.Platform;
import it.renvins.serverpulse.common.scheduler.TaskScheduler;
import it.renvins.serverpulse.fabric.ServerPulseFabricAPI;
import it.renvins.serverpulse.fabric.command.ServerPulseCommand;
import it.renvins.serverpulse.fabric.config.FabricConfiguration;
import it.renvins.serverpulse.fabric.config.FabricDatabaseConfiguration;
import it.renvins.serverpulse.fabric.config.FabricMetricsConfiguration;
import it.renvins.serverpulse.fabric.logger.FabricLogger;
import it.renvins.serverpulse.fabric.metrics.FabricPingRetriever;
import it.renvins.serverpulse.fabric.metrics.FabricTPSRetriever;
import it.renvins.serverpulse.fabric.platform.FabricPlatform;
import it.renvins.serverpulse.fabric.task.FabricScheduler;
import java.util.logging.Logger;
import lombok.Generated;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;

public class ServerPulseFabric
implements ModInitializer {
    public static final String MOD_ID = "serverpulse";
    public static final Logger LOGGER = Logger.getLogger("serverpulse");
    private final FabricConfiguration config = new FabricConfiguration(FabricLoader.getInstance().getConfigDir().resolve("serverpulse"), "config.yml");
    private final Platform platform;
    private final IDatabaseService databaseService;
    private final IMetricsService metricsService;
    private final ITPSRetriever tpsRetriever;
    private final IDiskRetriever diskRetriever;
    private final IPingRetriever pingRetriever;
    private MinecraftServer server;

    public ServerPulseFabric() {
        FabricLogger logger = new FabricLogger();
        this.platform = new FabricPlatform(this);
        FabricScheduler scheduler = new FabricScheduler();
        FabricDatabaseConfiguration dbConfig = new FabricDatabaseConfiguration(this.config);
        FabricMetricsConfiguration metricsConfig = new FabricMetricsConfiguration(this.config);
        this.databaseService = new DatabaseService((PulseLogger)logger, this.platform, (DatabaseConfiguration)dbConfig, (TaskScheduler)scheduler);
        this.metricsService = new MetricsService((PulseLogger)logger, this.platform, (MetricsConfiguration)metricsConfig, (TaskScheduler)scheduler);
        this.tpsRetriever = new FabricTPSRetriever();
        this.diskRetriever = new DiskRetriever(FabricLoader.getInstance().getGameDir().toFile());
        this.pingRetriever = new FabricPingRetriever(this);
    }

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopped);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(new ServerPulseCommand(this.config).createCommand()));
        LOGGER.info("ServerPulse for Fabric initialized - waiting for server starting...");
    }

    private void onServerStarting(MinecraftServer server) {
        this.server = server;
        LOGGER.info("Loading configuration...");
        this.config.load();
        ServerPulseProvider.register((ServerPulseAPI)new ServerPulseFabricAPI(this.databaseService, this.metricsService, this.tpsRetriever, this.diskRetriever, this.pingRetriever));
        this.databaseService.load();
        if (!this.platform.isEnabled()) {
            return;
        }
        this.metricsService.load();
        LOGGER.info("Starting tick monitoring task...");
        ((FabricTPSRetriever)this.tpsRetriever).startTickMonitor();
    }

    private void onServerStopped(MinecraftServer server) {
        this.databaseService.unload();
        this.metricsService.unload();
        ServerPulseProvider.unregister();
        this.server = null;
    }

    @Generated
    public MinecraftServer getServer() {
        return this.server;
    }
}

