/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.fabric.task;

import it.renvins.serverpulse.common.scheduler.Task;
import it.renvins.serverpulse.common.scheduler.TaskScheduler;
import it.renvins.serverpulse.fabric.ServerPulseFabric;
import it.renvins.serverpulse.fabric.task.FabricTask;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public class FabricScheduler
implements TaskScheduler {
    private final Queue<FabricTask> tasks = new ConcurrentLinkedDeque<FabricTask>();

    public FabricScheduler() {
        ServerTickEvents.END_SERVER_TICK.register(this::onServerTick);
    }

    public void runSync(Runnable task) {
        FabricTask taskWrapper = new FabricTask(task, false, 0L, 0L);
        this.tasks.add(taskWrapper);
    }

    public void runTaskTimer(Runnable task, long delayTicks, long periodTicks) {
        FabricTask fabricTask = new FabricTask(task, true, delayTicks, periodTicks);
        this.tasks.add(fabricTask);
    }

    public void runAsync(Runnable task) {
        CompletableFuture.runAsync(task).exceptionally(throwable -> {
            ServerPulseFabric.LOGGER.log(Level.SEVERE, "An error occurred while executing task!", (Throwable)throwable);
            return null;
        });
    }

    public Task runTaskTimerAsync(Runnable task, long delayTicks, long periodTicks) {
        FabricTask fabricTask = new FabricTask(() -> CompletableFuture.runAsync(task).exceptionally(throwable -> {
            ServerPulseFabric.LOGGER.log(Level.SEVERE, "An error occurred while executing task!", (Throwable)throwable);
            return null;
        }), true, delayTicks, periodTicks);
        this.tasks.add(fabricTask);
        return fabricTask;
    }

    private void onServerTick(MinecraftServer server) {
        this.tasks.removeIf(task -> {
            if (task.isCancelled()) {
                return true;
            }
            task.tick();
            return task.isCancelled();
        });
    }
}

