/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bungeecord.metrics;

import it.renvins.serverpulse.api.metrics.IPingRetriever;
import it.renvins.serverpulse.bungeecord.ServerPulseBungeeCord;
import lombok.Generated;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeeCordPingRetriever
implements IPingRetriever {
    private final ServerPulseBungeeCord plugin;

    @Override
    public int getMinPing() {
        int minPing = Integer.MAX_VALUE;
        if (this.plugin.getProxy().getPlayers().isEmpty()) {
            return 0;
        }
        for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
            minPing = Math.min(minPing, player.getPing());
        }
        return minPing;
    }

    @Override
    public int getMaxPing() {
        int maxPing = 0;
        if (this.plugin.getProxy().getPlayers().isEmpty()) {
            return 0;
        }
        for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
            maxPing = Math.max(maxPing, player.getPing());
        }
        return maxPing;
    }

    @Override
    public int getAveragePing() {
        int totalPing = 0;
        int playerCount = this.plugin.getProxy().getPlayers().size();
        if (playerCount == 0) {
            return 0;
        }
        for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
            totalPing += player.getPing();
        }
        return totalPing / playerCount;
    }

    @Generated
    public BungeeCordPingRetriever(ServerPulseBungeeCord plugin) {
        this.plugin = plugin;
    }
}

