/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.fabric.config;

import it.renvins.serverpulse.fabric.ServerPulseFabric;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import lombok.Generated;
import org.simpleyaml.configuration.file.YamlFile;

public class FabricConfiguration {
    private final String name;
    private final YamlFile config;

    public FabricConfiguration(Path dataDir, String name) {
        this.name = name;
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            ServerPulseFabric.LOGGER.log(Level.SEVERE, "Failed to create data directory: " + String.valueOf(dataDir), e);
        }
        this.config = new YamlFile(new File(dataDir.toFile(), name));
    }

    public boolean load() {
        try {
            if (!this.config.exists()) {
                if (this.copyDefaultsFromResource()) {
                    ServerPulseFabric.LOGGER.info("Created configuration file: " + this.name);
                } else {
                    this.config.createNewFile();
                    ServerPulseFabric.LOGGER.info("Configuration file not found, created a new one: " + this.name);
                }
            } else {
                ServerPulseFabric.LOGGER.info("Loading configuration file: " + this.name);
            }
            this.config.load();
            return true;
        }
        catch (Exception e) {
            ServerPulseFabric.LOGGER.log(Level.SEVERE, "Failed to load configuration file: " + this.name, e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyDefaultsFromResource() {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.name);){
            if (in != null) {
                Files.copy(in, this.config.getConfigurationFile().toPath(), new CopyOption[0]);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            ServerPulseFabric.LOGGER.log(Level.SEVERE, "Failed to copy default configuration file: " + this.name, e);
            return false;
        }
    }

    @Generated
    public YamlFile getConfig() {
        return this.config;
    }
}

