/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.logfilter.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import io.github._4drian3d.logfilter.common.configuration.Configuration;
import io.github._4drian3d.logfilter.common.configuration.Loader;
import io.github._4drian3d.logfilter.common.filter.Filters;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Plugin(id="logfilter", name="LogFilter-Velocity", version="3.2.0", description="Filter messages sent to your Velocity, Sponge, and Paper consoles", url="https://github.com/4drian3d/LogFilter", authors={"4drian3d"})
public final class LogFilterVelocity {
    private final Path pluginPath;
    private final Logger logger;

    @Inject
    public LogFilterVelocity(@DataDirectory Path pluginPath) {
        this.pluginPath = pluginPath;
        this.logger = LogManager.getLogger((String)"logfilter");
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.logger.info("Loading filter");
        if (!Loader.loadFiles(this.pluginPath, this.logger)) {
            return;
        }
        Configuration config = Loader.loadConfig(this.pluginPath, this.logger);
        if (config == null) {
            return;
        }
        String filter = Filters.applyFilter(config);
        this.logger.info("Correctly loaded {} filter", (Object)filter);
    }
}

