/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.logfilter.common.configuration;

import io.github._4drian3d.logfilter.common.configuration.Configuration;
import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.StandardLevel;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;

public final class Loader {
    private static final String CONFIG = "config.conf";

    private Loader() {
    }

    public static boolean loadFiles(Path dataFolder, Logger logger) {
        Path configPath;
        if (Files.notExists(dataFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(dataFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("Unable to create plugin directory", (Throwable)e);
                return false;
            }
        }
        if (Files.notExists(configPath = dataFolder.resolve(CONFIG), new LinkOption[0])) {
            try (InputStream in = Configuration.class.getClassLoader().getResourceAsStream(CONFIG);){
                Files.copy(Objects.requireNonNull(in), configPath, new CopyOption[0]);
            }
            catch (IOException e) {
                logger.error("Unable to create plugin configuration", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static Configuration loadConfig(Path dataFolder, Logger logger) {
        StandardLevel minimumLogLevel;
        List blockedStrings;
        ConfigurationNode node;
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(dataFolder.resolve(CONFIG))).build();
        try {
            node = loader.load();
        }
        catch (ConfigurateException e) {
            logger.error("Unable to load configuration");
            return null;
        }
        final boolean regex = node.node(new Object[]{"use-regex"}).getBoolean(false);
        try {
            blockedStrings = node.node(new Object[]{"blocked-strings"}).getList(TypeToken.get(String.class), Collections.emptyList());
        }
        catch (SerializationException e) {
            logger.error("Unable to get blocked-strings");
            return null;
        }
        try {
            minimumLogLevel = (StandardLevel)node.node(new Object[]{"minimum-log-level"}).get(StandardLevel.class, (Object)StandardLevel.INFO);
        }
        catch (SerializationException e) {
            logger.error("Unable to get serialize minimum log level");
            return null;
        }
        return new Configuration(){

            @Override
            public List<String> blockedStrings() {
                return blockedStrings;
            }

            @Override
            public boolean regexMode() {
                return regex;
            }

            @Override
            public StandardLevel minimumLogLevel() {
                return minimumLogLevel;
            }
        };
    }
}

