/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.logfilter.common.filter;

import io.github._4drian3d.logfilter.common.configuration.Configuration;
import io.github._4drian3d.logfilter.common.filter.CustomFilter;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;

public final class PatternFilter
extends CustomFilter {
    private final Pattern[] patterns;

    public PatternFilter(Configuration config) {
        super(config.minimumLogLevel().intLevel());
        this.patterns = config.blockedStrings().stream().map(Pattern::compile).collect(Collectors.toSet()).toArray(new Pattern[0]);
    }

    @Override
    protected Filter.Result logResult(String string, Level level) {
        if (level.intLevel() > this.minimumLogLevelSupported) {
            return Filter.Result.DENY;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].matcher(string).find()) continue;
            return Filter.Result.DENY;
        }
        return Filter.Result.NEUTRAL;
    }

    @Override
    public String getName() {
        return "Pattern";
    }
}

