/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.logfilter.common.filter;

import io.github._4drian3d.logfilter.common.configuration.Configuration;
import io.github._4drian3d.logfilter.common.filter.CustomFilter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;

public final class StringFilter
extends CustomFilter {
    private final String[] blockedStrings;

    public StringFilter(Configuration config) {
        super(config.minimumLogLevel().intLevel());
        this.blockedStrings = config.blockedStrings().toArray(new String[0]);
    }

    @Override
    protected Filter.Result logResult(String string, Level level) {
        if (level.intLevel() > this.minimumLogLevelSupported) {
            return Filter.Result.DENY;
        }
        for (int i = 0; i < this.blockedStrings.length; ++i) {
            if (!string.contains(this.blockedStrings[i])) continue;
            return Filter.Result.DENY;
        }
        return Filter.Result.NEUTRAL;
    }

    @Override
    public String getName() {
        return "Regular";
    }
}

