/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.logfilter.paper;

import io.github._4drian3d.logfilter.common.configuration.Configuration;
import io.github._4drian3d.logfilter.common.configuration.Loader;
import io.github._4drian3d.logfilter.common.filter.Filters;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LogBootstrap
implements PluginBootstrap {
    public void bootstrap(@NotNull BootstrapContext context) {
        Path pluginPath = context.getDataDirectory();
        Logger logger = LogManager.getLogger((String)"LogFilter");
        logger.info("Loading filter");
        if (!Loader.loadFiles(pluginPath, logger)) {
            return;
        }
        Configuration config = Loader.loadConfig(pluginPath, logger);
        if (config == null) {
            return;
        }
        String filter = Filters.applyFilter(config);
        logger.info("Correctly loaded {} filter", (Object)filter);
    }
}

