/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.bobj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.bobj.BOBJBone;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BOBJArmature {
    public String name;
    public Map<String, BOBJBone> bones = new HashMap<String, BOBJBone>();
    public List<BOBJBone> orderedBones = new ArrayList<BOBJBone>();
    public Matrix4f[] matrices;
    private boolean initialized;

    public BOBJArmature(String name) {
        this.name = name;
    }

    public void addBone(BOBJBone bone) {
        this.bones.put(bone.name, bone);
        this.orderedBones.add(bone);
    }

    public void initArmature() {
        if (!this.initialized) {
            for (BOBJBone bone : this.bones.values()) {
                if (!bone.parent.isEmpty()) {
                    bone.parentBone = this.bones.get(bone.parent);
                    bone.relBoneMat.set((Matrix4fc)bone.parentBone.boneMat);
                    bone.relBoneMat.invert();
                    bone.relBoneMat.mul((Matrix4fc)bone.boneMat);
                    continue;
                }
                bone.relBoneMat.set((Matrix4fc)bone.boneMat);
            }
            this.orderedBones.sort(Comparator.comparingInt(o -> o.index));
            this.matrices = new Matrix4f[this.orderedBones.size()];
            this.initialized = true;
        }
    }

    public void setupMatrices() {
        for (BOBJBone bone : this.orderedBones) {
            this.matrices[bone.index] = bone.compute();
        }
    }

    public void copyOrder(BOBJArmature armature) {
        for (BOBJBone bone : armature.orderedBones) {
            BOBJBone thisBone = this.bones.get(bone.name);
            if (thisBone == null) continue;
            thisBone.index = bone.index;
        }
        Collections.sort(this.orderedBones, (o1, o2) -> o1.index - o2.index);
    }
}

