/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.misc;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.camera.clips.CameraClip;
import mchorse.bbs_mod.camera.clips.misc.Subtitle;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.settings.values.core.ValueTransform;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.settings.values.numeric.ValueInt;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipContext;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.pose.Transform;

public class SubtitleClip
extends CameraClip {
    public ValueInt x = new ValueInt("x", 0);
    public ValueInt y = new ValueInt("y", 0);
    public ValueFloat size = new ValueFloat("size", Float.valueOf(10.0f));
    public ValueFloat anchorX = new ValueFloat("anchorX", Float.valueOf(0.5f));
    public ValueFloat anchorY = new ValueFloat("anchorY", Float.valueOf(0.5f));
    public ValueInt color = new ValueInt("color", -1);
    public ValueBoolean textShadow = new ValueBoolean("textShadow", true);
    public ValueFloat windowX = new ValueFloat("windowX", Float.valueOf(0.5f));
    public ValueFloat windowY = new ValueFloat("windowY", Float.valueOf(0.5f));
    public ValueInt background = new ValueInt("background", 0);
    public ValueFloat backgroundOffset = new ValueFloat("backgroundOffset", Float.valueOf(2.0f));
    public ValueFloat shadow = new ValueFloat("shadow", Float.valueOf(0.0f));
    public ValueBoolean shadowOpaque = new ValueBoolean("shadowOpaque", false);
    public ValueTransform transform = new ValueTransform("transform", new Transform());
    public ValueInt lineHeight = new ValueInt("lineHeight", 12);
    public ValueInt maxWidth = new ValueInt("maxWidth", 0);
    private Subtitle subtitle = new Subtitle();

    public static List<Subtitle> getSubtitles(ClipContext context) {
        return context.clipData.get("subtitles", ArrayList::new);
    }

    public SubtitleClip() {
        this.add(this.x);
        this.add(this.y);
        this.add(this.size);
        this.add(this.anchorX);
        this.add(this.anchorY);
        this.add(this.color);
        this.add(this.textShadow);
        this.add(this.windowX);
        this.add(this.windowY);
        this.add(this.background);
        this.add(this.backgroundOffset);
        this.add(this.shadow);
        this.add(this.shadowOpaque);
        this.add(this.transform);
        this.add(this.lineHeight);
        this.add(this.maxWidth);
    }

    @Override
    protected void applyClip(ClipContext context, Position position) {
        List<Subtitle> subtitles = SubtitleClip.getSubtitles(context);
        float factor = this.envelope.factorEnabled((Integer)this.duration.get(), (float)context.relativeTick + context.transition);
        int color = Colors.setA((Integer)this.color.get(), factor * Colors.getA((Integer)this.color.get()));
        this.subtitle.update((String)this.title.get(), (Integer)this.x.get(), (Integer)this.y.get(), ((Float)this.size.get()).floatValue(), ((Float)this.anchorX.get()).floatValue(), ((Float)this.anchorY.get()).floatValue(), color, (Boolean)this.textShadow.get());
        this.subtitle.updateWindow(((Float)this.windowX.get()).floatValue(), ((Float)this.windowY.get()).floatValue());
        this.subtitle.updateBackground((Integer)this.background.get(), ((Float)this.backgroundOffset.get()).floatValue(), ((Float)this.shadow.get()).floatValue(), (Boolean)this.shadowOpaque.get());
        this.subtitle.updateTransform((Transform)this.transform.get(), factor);
        this.subtitle.updateConstraints((Integer)this.lineHeight.get(), (Integer)this.maxWidth.get());
        subtitles.add(this.subtitle);
    }

    @Override
    protected Clip create() {
        return new SubtitleClip();
    }
}

