/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.blocks.entities.ModelProperties;
import mchorse.bbs_mod.entity.ActorEntity;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.renderers.FormRenderType;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.mixin.client.EntityRendererDispatcherInvoker;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanel;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIScreen;
import mchorse.bbs_mod.ui.model_blocks.UIModelBlockPanel;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class ModelBlockEntityRenderer
implements class_827<ModelBlockEntity> {
    private static ActorEntity entity;

    public static void renderShadow(class_4597 provider, class_4587 matrices, float tickDelta, double x, double y, double z, float tx, float ty, float tz) {
        ModelBlockEntityRenderer.renderShadow(provider, matrices, tickDelta, x, y, z, tx, ty, tz, 0.5f, 1.0f);
    }

    public static void renderShadow(class_4597 provider, class_4587 matrices, float tickDelta, double x, double y, double z, float tx, float ty, float tz, float radius, float opacity) {
        class_638 world = class_310.method_1551().field_1687;
        if (entity == null || entity.method_37908() != world) {
            entity = new ActorEntity(BBSMod.ACTOR_ENTITY, (class_1937)world);
        }
        entity.method_23327(x, y, z);
        ModelBlockEntityRenderer.entity.field_6038 = x;
        ModelBlockEntityRenderer.entity.field_5971 = y;
        ModelBlockEntityRenderer.entity.field_5989 = z;
        ModelBlockEntityRenderer.entity.field_6014 = x;
        ModelBlockEntityRenderer.entity.field_6036 = y;
        ModelBlockEntityRenderer.entity.field_5969 = z;
        double distance = class_310.method_1551().method_1561().method_3959(x, y, z);
        opacity = (float)((1.0 - distance / 256.0) * (double)opacity);
        matrices.method_22903();
        matrices.method_46416(tx, ty, tz);
        EntityRendererDispatcherInvoker.bbs$renderShadow(matrices, provider, (class_1297)entity, opacity, tickDelta, (class_4538)entity.method_37908(), radius);
        matrices.method_22909();
    }

    public ModelBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public boolean rendersOutsideBoundingBox(ModelBlockEntity blockEntity) {
        return blockEntity.getProperties().isGlobal();
    }

    public void render(ModelBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        ModelProperties properties = entity.getProperties();
        Transform transform = properties.getTransform();
        class_2338 pos = entity.method_11016();
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.0f, 0.5f);
        if (properties.getForm() != null && this.canRender(entity)) {
            matrices.method_22903();
            MatrixStackUtils.applyTransform(matrices, transform);
            int lightAbove = class_761.method_23794((class_1920)entity.method_10997(), (class_2338)pos.method_10069((int)transform.translate.x, (int)transform.translate.y, (int)transform.translate.z));
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            RenderSystem.enableDepthTest();
            FormUtilsClient.render(properties.getForm(), new FormRenderingContext().set(FormRenderType.MODEL_BLOCK, entity.getEntity(), matrices, lightAbove, overlay, tickDelta).camera(camera));
            RenderSystem.disableDepthTest();
            if (this.canRenderAxes(entity) && UIBaseMenu.renderAxes) {
                matrices.method_22903();
                MatrixStackUtils.scaleBack(matrices);
                Draw.coolerAxes(matrices, 0.5f, 0.01f, 0.51f, 0.02f);
                matrices.method_22909();
            }
            matrices.method_22909();
        }
        RenderSystem.disableDepthTest();
        if (class_310.method_1551().field_1690.field_1866) {
            Draw.renderBox(matrices, -0.5, 0.0, -0.5, 1.0, 1.0, 1.0, 0.0f, 0.5f, 1.0f, 0.5f);
        }
        matrices.method_22909();
        if (properties.isShadow()) {
            float tx = 0.5f + transform.translate.x;
            float ty = transform.translate.y;
            float tz = 0.5f + transform.translate.z;
            double x = (float)pos.method_10263() + tx;
            double y = (float)pos.method_10264() + ty;
            double z = (float)pos.method_10260() + tz;
            ModelBlockEntityRenderer.renderShadow(vertexConsumers, matrices, tickDelta, x, y, z, tx, ty, tz);
        }
    }

    public int method_33893() {
        return 196;
    }

    private boolean canRenderAxes(ModelBlockEntity entity) {
        UIBaseMenu uIBaseMenu = UIScreen.getCurrentMenu();
        if (uIBaseMenu instanceof UIDashboard) {
            boolean bl;
            UIDashboard dashboard = (UIDashboard)uIBaseMenu;
            UIDashboardPanel uIDashboardPanel = dashboard.getPanels().panel;
            if (uIDashboardPanel instanceof UIModelBlockPanel) {
                UIModelBlockPanel modelBlockPanel = (UIModelBlockPanel)uIDashboardPanel;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    private boolean canRender(ModelBlockEntity entity) {
        if (!entity.getProperties().isEnabled()) {
            return false;
        }
        if (!((Boolean)BBSSettings.renderAllModelBlocks.get()).booleanValue()) {
            return false;
        }
        UIBaseMenu uIBaseMenu = UIScreen.getCurrentMenu();
        if (uIBaseMenu instanceof UIDashboard) {
            UIDashboard dashboard = (UIDashboard)uIBaseMenu;
            UIDashboardPanel uIDashboardPanel = dashboard.getPanels().panel;
            if (uIDashboardPanel instanceof UIModelBlockPanel) {
                UIModelBlockPanel modelBlockPanel = (UIModelBlockPanel)uIDashboardPanel;
                return !modelBlockPanel.isEditing(entity) || UIModelBlockPanel.toggleRendering;
            }
        }
        return true;
    }
}

