/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.client.renderer.item;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.entities.StubEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.renderers.FormRenderType;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.items.GunProperties;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIScreen;
import mchorse.bbs_mod.ui.model_blocks.UIModelBlockEditorMenu;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_811;

@Environment(value=EnvType.CLIENT)
public class GunItemRenderer
implements BuiltinItemRendererRegistry.DynamicItemRenderer {
    private Map<class_1799, Item> map = new HashMap<class_1799, Item>();

    public void update() {
        Iterator<Item> it = this.map.values().iterator();
        while (it.hasNext()) {
            Item item = it.next();
            if (item.expiration <= 0) {
                it.remove();
            }
            --item.expiration;
            item.properties.update(item.formEntity);
        }
    }

    public void render(class_1799 stack, class_811 mode, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        Item item = this.get(stack);
        if (item != null) {
            UIBaseMenu uIBaseMenu;
            boolean zoom;
            GunProperties properties = item.properties;
            Form form = properties.getForm(mode);
            Transform transform = properties.getTransform(mode);
            boolean bl = zoom = mode.method_29998() && BBSModClient.getGunZoom() != null && properties.getZoomForm() != null;
            if (zoom) {
                form = properties.getZoomForm();
                transform = properties.zoomTransform;
            }
            if ((uIBaseMenu = UIScreen.getCurrentMenu()) instanceof UIModelBlockEditorMenu) {
                UIModelBlockEditorMenu editorMenu = (UIModelBlockEditorMenu)uIBaseMenu;
                if (editorMenu.currentSection == editorMenu.sectionZoom) {
                    form = editorMenu.getGunProperties().getZoomForm();
                    transform = editorMenu.getGunProperties().zoomTransform;
                }
            }
            if (form != null) {
                item.expiration = 20;
                matrices.method_22903();
                matrices.method_46416(0.5f, 0.0f, 0.5f);
                MatrixStackUtils.applyTransform(matrices, transform);
                RenderSystem.enableDepthTest();
                FormUtilsClient.render(form, new FormRenderingContext().set(FormRenderType.fromModelMode(mode), item.formEntity, matrices, light, overlay, class_310.method_1551().method_1488()).camera(class_310.method_1551().field_1773.method_19418()));
                RenderSystem.disableDepthTest();
                matrices.method_22909();
            }
        }
    }

    public Item get(class_1799 stack) {
        if (stack == null || stack.method_7909() != BBSMod.GUN_ITEM) {
            return null;
        }
        if (this.map.containsKey(stack)) {
            return this.map.get(stack);
        }
        Item item = new Item(GunProperties.get(stack));
        this.map.put(stack, item);
        return item;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Item {
        public GunProperties properties;
        public IEntity formEntity;
        public int expiration = 20;

        public Item(GunProperties properties) {
            this.properties = properties;
            this.formEntity = new StubEntity((class_1937)class_310.method_1551().field_1687);
        }
    }
}

