/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.data.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mchorse.bbs_mod.data.DataStorageContext;
import mchorse.bbs_mod.data.storage.IDataStorage;
import mchorse.bbs_mod.data.types.BaseType;

public abstract class DataStorage
implements IDataStorage {
    public static BaseType readFromStream(InputStream stream) throws IOException {
        DataInputStream dataInput = new DataInputStream(stream);
        char a = (char)dataInput.readByte();
        char b = (char)dataInput.readByte();
        char c = (char)dataInput.readByte();
        char d = (char)dataInput.readByte();
        String header = new String(new char[]{a, b, c, d});
        if (!header.equals("BBS1")) {
            throw new IllegalStateException("Given input stream has in invalid format! Header value is: " + header);
        }
        DataStorageContext context = new DataStorageContext(dataInput);
        context.read();
        BaseType type = BaseType.fromData(context);
        stream.close();
        return type;
    }

    public static void writeToStream(OutputStream stream, BaseType type) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(stream);
        DataStorageContext context = new DataStorageContext(dataOutput);
        dataOutput.writeByte(66);
        dataOutput.writeByte(66);
        dataOutput.writeByte(83);
        dataOutput.writeByte(49);
        type.traverseKeys(context);
        context.write();
        BaseType.toData(context, type);
        stream.close();
    }

    @Override
    public BaseType read() throws IOException {
        BaseType type = null;
        try (InputStream inputStream = this.getInputStream();){
            type = DataStorage.readFromStream(inputStream);
        }
        return type;
    }

    protected abstract InputStream getInputStream() throws IOException;

    @Override
    public void write(BaseType type) throws IOException {
        try (OutputStream outputStream = this.getOutputStream();){
            DataStorage.writeToStream(outputStream, type);
        }
    }

    protected abstract OutputStream getOutputStream() throws IOException;
}

