/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.l10n;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.l10n.L10n;
import mchorse.bbs_mod.l10n.keys.LangKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.IOUtils;
import mchorse.bbs_mod.utils.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class L10nUtils {
    public static final Link LAZY = Link.assets("lazy.json");

    public static String analyzeStrings(L10n l10n) {
        Map<String, LangKey> strings = l10n.getStrings();
        StringBuilder builder = new StringBuilder();
        HashMap<Link, Integer> perFile = new HashMap<Link, Integer>();
        for (LangKey langKey : strings.values()) {
            Link origin = langKey.getOrigin();
            if (origin == null) continue;
            int count = perFile.computeIfAbsent(origin, k -> 0);
            perFile.put(origin, count + 1);
        }
        if (!perFile.isEmpty()) {
            builder.append("Language strings per file:\n");
            for (Map.Entry entry : perFile.entrySet()) {
                builder.append("- ").append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        List<LangKey> missing = L10nUtils.findMissing(strings);
        List<LangKey> list = L10nUtils.findSurplus(strings);
        if (!missing.isEmpty()) {
            builder.append("\nMissing strings (" + missing.size() + "):\n");
            for (LangKey key : missing) {
                builder.append("- ").append(key.content);
                if (!key.key.isEmpty()) {
                    builder.append(" - ").append(key.key);
                }
                builder.append("\n");
            }
        }
        if (!list.isEmpty()) {
            builder.append("\nSurplus strings (" + list.size() + "):\n");
            for (LangKey key : list) {
                builder.append("- ").append(key.content);
                if (!key.key.isEmpty()) {
                    builder.append(" - ").append(key.key);
                }
                builder.append("\n");
            }
        }
        builder.append("\nTotal language keys: ").append(strings.size());
        return builder.toString();
    }

    public static List<LangKey> findSurplus(Map<String, LangKey> strings) {
        ArrayList<LangKey> surplus = new ArrayList<LangKey>();
        for (LangKey key : strings.values()) {
            if (key.wasRequested) continue;
            surplus.add(key);
        }
        L10nUtils.sortList(surplus);
        return surplus;
    }

    public static List<LangKey> findMissing(Map<String, LangKey> strings) {
        ArrayList<LangKey> missing = new ArrayList<LangKey>();
        for (LangKey key : strings.values()) {
            if (key.getOrigin() != null) continue;
            missing.add(key);
        }
        L10nUtils.sortList(missing);
        return missing;
    }

    public static void compile(File export, Map<String, LangKey> strings) {
        HashMap<Link, List> keysPerFile = new HashMap<Link, List>();
        export.mkdirs();
        for (LangKey key : strings.values()) {
            Link origin = key.getOrigin() == null ? LAZY : key.getOrigin();
            keysPerFile.computeIfAbsent(origin, k -> new ArrayList()).add(key);
        }
        for (List list : keysPerFile.values()) {
            L10nUtils.sortList(list);
        }
        List<LangKey> surplus = L10nUtils.findSurplus(strings);
        for (Map.Entry entry : keysPerFile.entrySet()) {
            Link key = (Link)entry.getKey();
            File file = new File(export, "lang." + key.source + "_" + key.path.replaceAll("/", "."));
            MapType out = new MapType(false);
            for (LangKey k2 : (List)entry.getValue()) {
                if (surplus.contains(k2)) continue;
                out.putString(k2.key, k2.content);
            }
            DataToString.writeSilently(file, out, true);
        }
    }

    public static void sortList(List<LangKey> list) {
        HashMap<String, ArrayList<LangKey>> prefixes = new HashMap<String, ArrayList<LangKey>>();
        ArrayList<String> ordered = new ArrayList<String>();
        for (LangKey key : list) {
            String k = key.key;
            int endIndex = k.lastIndexOf(46);
            String prefix = endIndex == -1 ? k : k.substring(0, endIndex);
            ArrayList<LangKey> keys = (ArrayList<LangKey>)prefixes.get(prefix);
            if (keys == null) {
                keys = new ArrayList<LangKey>();
                prefixes.put(prefix, keys);
                ordered.add(prefix);
            }
            keys.add(key);
        }
        for (List keys : prefixes.values()) {
            keys.sort(Comparator.comparing(a -> a.key));
        }
        ordered.sort((a, b) -> {
            String[] aSplits = a.split("\\.");
            String[] bSplits = b.split("\\.");
            int c = Math.min(aSplits.length, bSplits.length);
            for (int i = 0; i < c; ++i) {
                int diff = aSplits[i].compareTo(bSplits[i]);
                if (diff == 0) continue;
                return diff;
            }
            return a.compareTo((String)b);
        });
        list.clear();
        for (String prefix : ordered) {
            list.addAll((Collection)prefixes.get(prefix));
        }
    }

    public static List<Pair<String, String>> readAdditionalLanguages(File file) {
        if (file.isFile()) {
            try {
                MapType mapType = DataToString.mapFromString(IOUtils.readText(file));
                ArrayList<Pair<String, String>> additionalLanguages = new ArrayList<Pair<String, String>>();
                for (String key : mapType.keys()) {
                    additionalLanguages.add(new Pair<String, String>(mapType.getString(key), key));
                }
                return additionalLanguages;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }
}

