/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.forms.FormCategories;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.categories.FormCategory;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.forms.IUIFormList;
import mchorse.bbs_mod.ui.forms.categories.UIFormCategory;
import mchorse.bbs_mod.ui.forms.categories.UIRecentFormCategory;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.Direction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_308;

@Environment(value=EnvType.CLIENT)
public class UIFormList
extends UIElement {
    public IUIFormList palette;
    public UIScrollView forms;
    public UIElement bar;
    public UITextbox search;
    public UIIcon edit;
    public UIIcon close;
    private UIFormCategory recent;
    private List<UIFormCategory> categories = new ArrayList<UIFormCategory>();
    private long lastUpdate;
    private int lastScroll;

    public UIFormList(IUIFormList palette) {
        this.palette = palette;
        this.forms = UI.scrollView(0, 0, new UIElement[0]);
        this.forms.scroll.cancelScrolling();
        this.bar = new UIElement();
        this.search = new UITextbox(100, this::search).placeholder(UIKeys.FORMS_LIST_SEARCH);
        this.edit = new UIIcon(Icons.EDIT, this::edit);
        this.edit.tooltip(UIKeys.FORMS_LIST_EDIT, Direction.TOP);
        this.close = new UIIcon(Icons.CLOSE, this::close);
        this.forms.full(this);
        this.bar.relative(this).x(10).y(1.0f, -30).w(1.0f, -20).h(20).row().height(20);
        this.close.w(20);
        this.bar.add(this.search, this.edit, this.close);
        this.add(this.forms, this.bar);
        this.search.keys().register(Keys.FORMS_FOCUS, this::focusSearch);
        this.markContainer();
        this.setupForms(BBSModClient.getFormCategories());
    }

    private void focusSearch() {
        this.search.clickItself();
    }

    public void setupForms(FormCategories forms) {
        this.categories.clear();
        this.forms.removeAll();
        for (FormCategory category : forms.getAllCategories()) {
            UIFormCategory uiCategory = category.createUI(this);
            this.forms.add((IUIElement)uiCategory);
            this.categories.add(uiCategory);
            if (!(uiCategory instanceof UIRecentFormCategory)) continue;
            this.recent = uiCategory;
        }
        this.categories.get(this.categories.size() - 1).marginBottom(40);
        this.resize();
        this.lastUpdate = forms.getLastUpdate();
    }

    private void search(String search) {
        search = search.trim();
        for (UIFormCategory category : this.categories) {
            category.search(search);
        }
    }

    private void edit(UIIcon b) {
        this.palette.toggleEditor();
    }

    private void close(UIIcon b) {
        this.palette.exit();
    }

    public void selectCategory(UIFormCategory category, Form form, boolean notify) {
        this.deselect();
        category.selected = form;
        if (notify) {
            this.palette.accept(form);
        }
    }

    public void deselect() {
        for (UIFormCategory category : this.categories) {
            category.selected = null;
        }
    }

    public UIFormCategory getSelectedCategory() {
        for (UIFormCategory category : this.categories) {
            if (category.selected == null) continue;
            return category;
        }
        return null;
    }

    public Form getSelected() {
        UIFormCategory category = this.getSelectedCategory();
        return category == null ? null : category.selected;
    }

    public void setSelected(Form form) {
        boolean found = false;
        this.deselect();
        for (UIFormCategory category : this.categories) {
            int index = category.category.getForms().indexOf(form);
            if (index == -1) {
                category.selected = null;
                continue;
            }
            found = true;
            category.select(category.category.getForms().get(index), false);
        }
        if (!found && form != null) {
            Form copy = FormUtils.copy(form);
            this.recent.category.addForm(copy);
            this.recent.select(copy, false);
        }
    }

    @Override
    public void render(UIContext context) {
        Form selected;
        FormCategories categories = BBSModClient.getFormCategories();
        if (this.lastScroll >= 0) {
            this.forms.scroll.scrollTo(this.lastScroll);
            this.lastScroll = -1;
        }
        if (this.lastUpdate != categories.getLastUpdate()) {
            this.lastScroll = (int)this.forms.scroll.getScroll();
            selected = this.getSelected();
            this.setupForms(categories);
            this.setSelected(selected);
        }
        class_308.method_24211();
        super.render(context);
        class_308.method_24210();
        selected = this.getSelected();
        if (selected != null) {
            String displayName = selected.getDisplayName();
            String id = selected.getFormId();
            FontRenderer font = context.batcher.getFont();
            int w = Math.max(font.getWidth(displayName), font.getWidth(id));
            int x = this.search.area.x;
            int y = this.search.area.y - 24;
            context.batcher.box(x, y, x + w + 8, this.search.area.y, -2013265920);
            context.batcher.textShadow(displayName, x + 4, y + 4);
            context.batcher.textShadow(id, x + 4, y + 14, -3355444);
        }
    }
}

