/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.color;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.settings.values.ui.ValueColors;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.color.UIColorPalette;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.framework.elements.utils.EventPropagation;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class UIColorPicker
extends UIElement {
    public static final int COLOR_SLIDER_HEIGHT = 50;
    public static ValueColors recentColors = new ValueColors("recent");
    public Color color = new Color();
    public Consumer<Integer> callback;
    public UITextbox input;
    public UIColorPalette recent;
    public UIColorPalette favorite;
    public boolean editAlpha;
    public Area red = new Area();
    public Area green = new Area();
    public Area blue = new Area();
    public Area alpha = new Area();
    private int dragging = -1;
    private Color hsv = new Color();

    public static void renderAlphaPreviewQuad(Batcher2D batcher, int x1, int y1, int x2, int y2, Color color) {
        Matrix4f matrix4f = batcher.getContext().method_51448().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        builder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        builder.method_22918(matrix4f, (float)x1, (float)y1, 0.0f).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
        builder.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
        builder.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
        builder.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        builder.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        builder.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    public UIColorPicker(Consumer<Integer> callback) {
        this.callback = callback;
        this.input = new UITextbox(7, string -> {
            this.setValue(Colors.parse(string));
            this.callback();
        });
        this.input.context((ContextMenuManager menu) -> menu.action(Icons.FAVORITE, UIKeys.COLOR_CONTEXT_FAVORITES_ADD, () -> this.addToFavorites(this.color)));
        this.recent = new UIColorPalette(color -> {
            this.setColor(color.getARGBColor());
            this.updateColor();
        }).colors(recentColors.getCurrentColors());
        this.recent.context((ContextMenuManager menu) -> {
            int index = this.recent.getIndex(this.getContext());
            if (this.recent.hasColor(index)) {
                menu.action(Icons.FAVORITE, UIKeys.COLOR_CONTEXT_FAVORITES_ADD, () -> this.addToFavorites(this.recent.colors.get(index)));
            }
        });
        this.favorite = new UIColorPalette(color -> {
            this.setColor(color.getARGBColor());
            this.updateColor();
        }).colors(BBSSettings.favoriteColors.getCurrentColors());
        this.favorite.context((ContextMenuManager menu) -> {
            int index = this.favorite.getIndex(this.getContext());
            if (this.favorite.hasColor(index)) {
                menu.action(Icons.REMOVE, UIKeys.COLOR_CONTEXT_FAVORITES_REMOVE, () -> this.removeFromFavorites(index));
            }
        });
        this.input.relative(this).set(5, 5, 0, 20).w(1.0f, -35);
        this.favorite.relative(this).xy(5, 95).w(1.0f, -10);
        this.recent.relative(this.favorite).w(1.0f);
        this.eventPropagataion(EventPropagation.BLOCK_INSIDE).add(this.input, this.favorite, this.recent);
    }

    public UIColorPicker editAlpha() {
        this.editAlpha = true;
        this.input.textbox.setLength(9);
        return this;
    }

    public void updateField() {
        this.input.setText(this.color.stringify(this.editAlpha));
    }

    public void updateColor() {
        this.updateField();
        this.callback();
    }

    protected void callback() {
        if (this.callback != null) {
            this.callback.accept(this.editAlpha ? this.color.getARGBColor() : this.color.getRGBColor());
        }
    }

    public void setColor(int color) {
        this.setValue(color);
        this.updateField();
    }

    public void setValue(int color) {
        this.color.set(color, this.editAlpha);
        Colors.RGBtoHSV(this.hsv, this.color.r, this.color.g, this.color.b);
        this.hsv.a = this.color.a;
    }

    public void setup(int x, int y) {
        this.xy(x, y);
        this.setupSize();
    }

    private void setupSize() {
        int width = 200;
        int recent = this.recent.colors.isEmpty() ? 0 : this.recent.getHeight(width - 10);
        int favorite = this.favorite.colors.isEmpty() ? 0 : this.favorite.getHeight(width - 10);
        int base = 85;
        base += favorite > 0 ? favorite + 15 : 0;
        this.h(base += recent > 0 ? recent + 15 : 0);
        this.favorite.h(favorite);
        this.recent.h(recent);
        if (favorite > 0) {
            this.recent.y(1.0f, 15);
        } else {
            this.recent.y(0);
        }
    }

    private void addToRecent() {
        recentColors.addColor(this.color);
    }

    private void addToFavorites(Color color) {
        BBSSettings.favoriteColors.addColor(color);
        this.setupSize();
        this.resize();
    }

    private void removeFromFavorites(int index) {
        BBSSettings.favoriteColors.remove(index);
        this.setupSize();
        this.resize();
    }

    @Override
    public void resize() {
        super.resize();
        int c = this.editAlpha ? 4 : 3;
        int h = 50 / c;
        int w = this.area.w - 10;
        int remainder = 50 - h * c;
        int y = this.area.y + 30;
        this.red.set(this.area.x + 5, y, w, h);
        if (this.editAlpha) {
            this.green.set(this.area.x + 5, y + h, w, h);
            this.blue.set(this.area.x + 5, y + h + h, w, h + remainder);
            this.alpha.set(this.area.x + 5, y + 50 - h, w, h);
        } else {
            this.green.set(this.area.x + 5, y + h, w, h + remainder);
            this.blue.set(this.area.x + 5, y + 50 - h, w, h);
        }
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (this.red.isInside(context)) {
            this.dragging = 1;
            return true;
        }
        if (this.green.isInside(context)) {
            this.dragging = 2;
            return true;
        }
        if (this.blue.isInside(context)) {
            this.dragging = 3;
            return true;
        }
        if (this.alpha.isInside(context) && this.editAlpha) {
            this.dragging = 4;
            return true;
        }
        if (!this.area.isInside(context)) {
            this.removeFromParent();
            this.addToRecent();
        }
        return super.subMouseClicked(context);
    }

    @Override
    public boolean subMouseReleased(UIContext context) {
        this.dragging = -1;
        return super.subMouseReleased(context);
    }

    @Override
    protected boolean subKeyPressed(UIContext context) {
        if (context.isPressed(256)) {
            this.removeFromParent();
            this.addToRecent();
            return true;
        }
        return super.subKeyPressed(context);
    }

    @Override
    public void render(UIContext context) {
        Color color;
        boolean isHsv = (Boolean)BBSSettings.hsvColorPicker.get();
        Color color2 = color = isHsv ? this.hsv : this.color;
        if (this.dragging >= 0) {
            float factor = (float)(context.mouseX - (this.red.x + 7)) / (float)(this.red.w - 14);
            color.set(MathUtils.clamp(factor, 0.0f, 1.0f), this.dragging);
            if (isHsv) {
                Colors.HSVtoRGB(this.color, this.hsv.r, this.hsv.g, this.hsv.b);
                this.color.a = this.hsv.a;
            }
            this.updateColor();
        }
        this.area.render(context.batcher, -3355444);
        this.renderRect(context.batcher, this.area.ex() - 25, this.area.y + 5, this.area.ex() - 5, this.area.y + 25);
        context.batcher.outline(this.area.ex() - 25, this.area.y + 5, this.area.ex() - 5, this.area.y + 25, 0x44000000);
        if (this.editAlpha) {
            context.batcher.iconArea(Icons.CHECKBOARD, this.alpha.x, this.red.y, this.alpha.w, this.alpha.ey() - this.red.y);
        }
        Color temp = new Color();
        int left = 0;
        int right = 0;
        if (isHsv) {
            temp.a = color.a;
            for (int i = 0; i < 6; ++i) {
                Colors.HSVtoRGB(temp, (float)i / 6.0f, 1.0f, 1.0f);
                left = temp.getARGBColor();
                Colors.HSVtoRGB(temp, (float)(i + 1) / 6.0f, 1.0f, 1.0f);
                right = temp.getARGBColor();
                context.batcher.gradientHBox(this.red.x((float)i / 6.0f), this.red.y, this.red.x((float)(i + 1) / 6.0f), this.red.ey(), left, right);
            }
            Colors.HSVtoRGB(temp, this.hsv.r, 0.0f, this.hsv.b);
            left = temp.getARGBColor();
            Colors.HSVtoRGB(temp, this.hsv.r, 1.0f, this.hsv.b);
            right = temp.getARGBColor();
            context.batcher.gradientHBox(this.green.x, this.green.y, this.green.ex(), this.green.ey(), left, right);
            Colors.HSVtoRGB(temp, this.hsv.r, this.hsv.g, 0.0f);
            left = temp.getARGBColor();
            Colors.HSVtoRGB(temp, this.hsv.r, this.hsv.g, 1.0f);
            right = temp.getARGBColor();
            context.batcher.gradientHBox(this.blue.x, this.blue.y, this.blue.ex(), this.blue.ey(), left, right);
            if (this.editAlpha) {
                Colors.HSVtoRGB(temp, this.hsv.r, this.hsv.g, this.hsv.b);
                temp.a = 0.0f;
                left = temp.getARGBColor();
                Colors.HSVtoRGB(temp, this.hsv.r, this.hsv.g, this.hsv.b);
                temp.a = 1.0f;
                right = temp.getARGBColor();
                context.batcher.gradientHBox(this.alpha.x, this.alpha.y, this.alpha.ex(), this.alpha.ey(), left, right);
            }
        } else {
            temp.copy((Color)color).r = 0.0f;
            left = temp.getARGBColor();
            temp.copy((Color)color).r = 1.0f;
            right = temp.getARGBColor();
            context.batcher.gradientHBox(this.red.x, this.red.y, this.red.ex(), this.red.ey(), left, right);
            temp.copy((Color)color).g = 0.0f;
            left = temp.getARGBColor();
            temp.copy((Color)color).g = 1.0f;
            right = temp.getARGBColor();
            context.batcher.gradientHBox(this.green.x, this.green.y, this.green.ex(), this.green.ey(), left, right);
            temp.copy((Color)color).b = 0.0f;
            left = temp.getARGBColor();
            temp.copy((Color)color).b = 1.0f;
            right = temp.getARGBColor();
            context.batcher.gradientHBox(this.blue.x, this.blue.y, this.blue.ex(), this.blue.ey(), left, right);
            if (this.editAlpha) {
                temp.copy((Color)color).a = 0.0f;
                left = temp.getARGBColor();
                temp.copy((Color)color).a = 1.0f;
                right = temp.getARGBColor();
                context.batcher.gradientHBox(this.alpha.x, this.alpha.y, this.alpha.ex(), this.alpha.ey(), left, right);
            }
        }
        context.batcher.outline(this.red.x, this.red.y, this.red.ex(), this.editAlpha ? (float)this.alpha.ey() : (float)this.blue.ey(), 0x44000000);
        this.renderMarker(context.batcher, this.red.x + 7 + (int)((float)(this.red.w - 14) * color.r), this.red.my());
        this.renderMarker(context.batcher, this.green.x + 7 + (int)((float)(this.green.w - 14) * color.g), this.green.my());
        this.renderMarker(context.batcher, this.blue.x + 7 + (int)((float)(this.blue.w - 14) * color.b), this.blue.my());
        if (this.editAlpha) {
            this.renderMarker(context.batcher, this.alpha.x + 7 + (int)((float)(this.alpha.w - 14) * color.a), this.alpha.my());
        }
        if (!this.favorite.colors.isEmpty()) {
            context.batcher.text(UIKeys.COLOR_FAVORITE.get(), this.favorite.area.x, this.favorite.area.y - 10, -7829368);
        }
        if (!this.recent.colors.isEmpty()) {
            context.batcher.text(UIKeys.COLOR_RECENT.get(), this.recent.area.x, this.recent.area.y - 10, -7829368);
        }
        super.render(context);
    }

    public void renderRect(Batcher2D batcher, int x1, int y1, int x2, int y2) {
        if (this.editAlpha) {
            batcher.iconArea(Icons.CHECKBOARD, x1, y1, x2 - x1, y2 - y1);
            UIColorPicker.renderAlphaPreviewQuad(batcher, x1, y1, x2, y2, this.color);
        } else {
            batcher.box(x1, y1, x2, y2, this.color.getARGBColor());
        }
    }

    private void renderMarker(Batcher2D batcher, int x, int y) {
        batcher.box(x - 4, y - 4, x + 4, y + 4, -16777216);
        batcher.box(x - 3, y - 3, x + 3, y + 3, -1);
        batcher.box(x - 2, y - 2, x + 2, y + 2, -3355444);
    }
}

