/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs.IUIKeyframeGraph;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs.KeyframeType;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.shapes.IKeyframeShapeRenderer;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.shapes.KeyframeShapeRenderers;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.Scale;
import mchorse.bbs_mod.ui.utils.Scroll;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeShape;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class UIKeyframeDopeSheet
implements IUIKeyframeGraph {
    private UIKeyframes keyframes;
    private List<UIKeyframeSheet> sheets = new ArrayList<UIKeyframeSheet>();
    private Scroll dopeSheet;
    private double trackHeight;

    public UIKeyframeDopeSheet(UIKeyframes keyframes) {
        this.keyframes = keyframes;
        this.dopeSheet = new Scroll(this.keyframes.area);
        this.setTrackHeight(16.0);
    }

    public double getTrackHeight() {
        return this.trackHeight;
    }

    public void setTrackHeight(double height) {
        this.trackHeight = MathUtils.clamp(height, 8.0, 100.0);
        this.dopeSheet.scrollSpeed = (int)this.trackHeight * 2;
        this.dopeSheet.scrollSize = (int)this.trackHeight * this.sheets.size() + 25;
        this.dopeSheet.clamp();
    }

    public Scroll getYAxis() {
        return this.dopeSheet;
    }

    public int getDopeSheetY() {
        return this.keyframes.area.y + 25 - (int)this.dopeSheet.getScroll();
    }

    public int getDopeSheetY(int sheet) {
        return this.getDopeSheetY() + sheet * (int)this.trackHeight;
    }

    public int getDopeSheetY(UIKeyframeSheet sheet) {
        return this.getDopeSheetY(this.sheets.indexOf(sheet));
    }

    private boolean isNear(double x, double y, int mouseX, int mouseY, boolean checkOnlyX) {
        if (checkOnlyX) {
            return Math.pow((double)mouseX - x, 2.0) < 25.0;
        }
        return Math.pow((double)mouseX - x, 2.0) + Math.pow((double)mouseY - y, 2.0) < 25.0;
    }

    @Override
    public void resetView() {
        this.keyframes.resetViewX();
    }

    @Override
    public List<UIKeyframeSheet> getSheets() {
        return this.sheets;
    }

    public void removeAllSheets() {
        this.sheets.clear();
    }

    public void addSheet(UIKeyframeSheet sheet) {
        this.sheets.add(sheet);
    }

    @Override
    public void selectByX(int mouseX) {
        for (int i = 0; i < this.sheets.size(); ++i) {
            UIKeyframeSheet sheet = this.sheets.get(i);
            List keyframes = sheet.channel.getKeyframes();
            for (int j = 0; j < keyframes.size(); ++j) {
                int y;
                Keyframe keyframe = keyframes.get(j);
                int x = this.keyframes.toGraphX(keyframe.getTick());
                if (!this.isNear(x, y = this.getDopeSheetY(i) + (int)this.trackHeight / 2, mouseX, 0, true)) continue;
                sheet.selection.add(j);
            }
        }
        this.pickSelected();
    }

    @Override
    public void selectInArea(Area area) {
        List<UIKeyframeSheet> sheets = this.getSheets();
        for (int i = 0; i < sheets.size(); ++i) {
            UIKeyframeSheet sheet = sheets.get(i);
            List keyframes = sheet.channel.getKeyframes();
            for (int j = 0; j < keyframes.size(); ++j) {
                int y;
                Keyframe keyframe = keyframes.get(j);
                int x = this.keyframes.toGraphX(keyframe.getTick());
                if (!area.isInside(x, y = this.getDopeSheetY(i) + (int)this.trackHeight / 2)) continue;
                sheet.selection.add(j);
            }
        }
        this.pickSelected();
    }

    @Override
    public UIKeyframeSheet getSheet(int mouseY) {
        int dopeSheetY = this.getDopeSheetY();
        int index = (mouseY - dopeSheetY) / (int)this.trackHeight;
        return CollectionUtils.getSafe(this.sheets, index);
    }

    @Override
    public boolean addKeyframe(int mouseX, int mouseY) {
        float tick = (float)this.keyframes.fromGraphX(mouseX);
        UIKeyframeSheet sheet = this.getSheet(mouseY);
        if (!Window.isShiftPressed()) {
            tick = Math.round(tick);
        }
        if (sheet != null) {
            this.addKeyframe(sheet, tick, null);
        }
        return sheet != null;
    }

    @Override
    public Pair<Keyframe, KeyframeType> findKeyframe(int mouseX, int mouseY) {
        UIKeyframeSheet sheet = this.getSheet(mouseY);
        if (sheet == null) {
            return null;
        }
        List keyframes = sheet.channel.getKeyframes();
        int i = this.sheets.indexOf(sheet);
        for (int j = 0; j < keyframes.size(); ++j) {
            int y;
            Keyframe keyframe = keyframes.get(j);
            int x = this.keyframes.toGraphX(keyframe.getTick());
            if (!this.isNear(x, y = this.getDopeSheetY(i) + (int)this.trackHeight / 2, mouseX, mouseY, false)) continue;
            return new Pair<Keyframe, KeyframeType>(keyframe, KeyframeType.REGULAR);
        }
        return null;
    }

    @Override
    public void pickKeyframe(Keyframe keyframe) {
        this.keyframes.pickKeyframe(keyframe);
    }

    @Override
    public void selectKeyframe(Keyframe keyframe) {
        this.clearSelection();
        UIKeyframeSheet sheet = this.getSheet(keyframe);
        if (sheet != null) {
            sheet.selection.add(keyframe);
            this.pickKeyframe(keyframe);
            double x = keyframe.getTick();
            int y = (int)((double)this.sheets.indexOf(sheet) * this.trackHeight) + 25;
            this.keyframes.getXAxis().shiftIntoMiddle(x);
            this.dopeSheet.scrollTo((int)((double)y - ((double)this.dopeSheet.area.h - this.trackHeight) / 2.0));
        }
    }

    @Override
    public void resize() {
        this.dopeSheet.clamp();
    }

    @Override
    public boolean mouseClicked(UIContext context) {
        return this.dopeSheet.mouseClicked(context);
    }

    @Override
    public void mouseReleased(UIContext context) {
        this.dopeSheet.mouseReleased(context);
    }

    @Override
    public void mouseScrolled(UIContext context) {
        if (context.mouseWheelHorizontal != 0.0) {
            double offsetX = (double)(25.0f * ((Float)BBSSettings.scrollingSensitivityHorizontal.get()).floatValue()) * context.mouseWheelHorizontal / this.keyframes.getXAxis().getZoom();
            this.keyframes.getXAxis().setShift(this.keyframes.getXAxis().getShift() - offsetX);
        } else if (Window.isShiftPressed()) {
            this.dopeSheet.mouseScroll(context);
        } else if (Window.isAltPressed()) {
            this.setTrackHeight(this.trackHeight - context.mouseWheel);
        } else if (context.mouseWheel != 0.0) {
            this.keyframes.getXAxis().zoomAnchor(Scale.getAnchorX(context, this.keyframes.area), Math.copySign(this.keyframes.getXAxis().getZoomFactor(), context.mouseWheel));
        }
    }

    @Override
    public void handleMouse(UIContext context, int lastX, int lastY) {
        this.dopeSheet.drag(context);
        if (this.keyframes.isNavigating()) {
            int mouseX = context.mouseX;
            int mouseY = context.mouseY;
            double offset = (double)(mouseX - lastX) / this.keyframes.getXAxis().getZoom();
            this.keyframes.getXAxis().setShift(this.keyframes.getXAxis().getShift() - offset);
            this.dopeSheet.scrollBy(-(mouseY - lastY));
        }
    }

    @Override
    public void dragKeyframes(UIContext context, Pair<Keyframe, KeyframeType> type, int originalX, int originalY, float originalT, Object originalV) {
        float offset = (float)(this.keyframes.fromGraphX(originalX) - (double)originalT);
        float tick = (float)this.keyframes.fromGraphX(context.mouseX) - offset;
        if (!Window.isShiftPressed()) {
            tick = Math.round(this.keyframes.fromGraphX(context.mouseX) - (double)offset);
        }
        this.setTick(tick, false);
        this.keyframes.triggerChange();
    }

    @Override
    public void render(UIContext context) {
        this.renderGrid(context);
        this.renderGraph(context);
    }

    protected void renderGrid(UIContext context) {
        block19: {
            block20: {
                block18: {
                    int x;
                    Area area = this.keyframes.area;
                    int mult = this.keyframes.getXAxis().getMult();
                    int hx = this.keyframes.getDuration() / mult;
                    int ht = (int)this.keyframes.fromGraphX(area.x);
                    for (int j = Math.max(ht / mult, 0); j <= hx && (x = this.keyframes.toGraphX(j * mult)) < area.ex(); ++j) {
                        Iterator label = this.keyframes.getConverter() == null ? String.valueOf(j * mult) : this.keyframes.getConverter().format(j * mult);
                        context.batcher.box(x, area.y, x + 1, area.ey(), Colors.setA(-1, 0.25f));
                        context.batcher.text((String)((Object)label), x + 4, area.y + 4);
                    }
                    if (!area.isInside(context)) {
                        return;
                    }
                    if (!this.keyframes.isStacking()) break block18;
                    ArrayList<UIKeyframeSheet> sheets = new ArrayList<UIKeyframeSheet>();
                    float currentTick = (float)this.keyframes.fromGraphX(context.mouseX);
                    for (UIKeyframeSheet sheet : this.getSheets()) {
                        if (!sheet.selection.hasAny()) continue;
                        sheets.add(sheet);
                    }
                    for (UIKeyframeSheet current : sheets) {
                        List<Keyframe> selected = current.selection.getSelected();
                        float mmin = 2.1474836E9f;
                        float mmax = -2.1474836E9f;
                        for (Keyframe keyframe : selected) {
                            mmin = Math.min(keyframe.getTick(), mmin);
                            mmax = Math.max(keyframe.getTick(), mmax);
                        }
                        float length = mmax - mmin + this.keyframes.getStackOffset();
                        int times = (int)Math.max(1.0, Math.ceil((currentTick - mmax) / length));
                        float x2 = 0.0f;
                        for (int i = 0; i < times; ++i) {
                            for (Keyframe keyframe : selected) {
                                float tick = mmax + this.keyframes.getStackOffset() + (keyframe.getTick() - mmin) + x2;
                                this.renderPreviewKeyframe(context, current, tick, 0xFFFF33);
                            }
                            x2 += length;
                        }
                    }
                    break block19;
                }
                if (!Window.isCtrlPressed()) break block20;
                UIKeyframeSheet sheet = this.getSheet(context.mouseY);
                if (sheet == null) break block19;
                float tick = (float)this.keyframes.fromGraphX(context.mouseX);
                if (!Window.isShiftPressed()) {
                    tick = Math.round(tick);
                }
                this.renderPreviewKeyframe(context, sheet, tick, -1);
                break block19;
            }
            if (Window.isAltPressed() && !Window.isShiftPressed()) {
                ArrayList<UIKeyframeSheet> sheets = new ArrayList<UIKeyframeSheet>();
                for (UIKeyframeSheet sheet : this.getSheets()) {
                    if (!sheet.selection.hasAny()) continue;
                    sheets.add(sheet);
                }
                if (sheets.size() == 1) {
                    UIKeyframeSheet current = (UIKeyframeSheet)sheets.get(0);
                    UIKeyframeSheet hovered = this.getSheet(context.mouseY);
                    if (hovered == null || current.channel.getFactory() != hovered.channel.getFactory()) {
                        return;
                    }
                    List<Keyframe> selected = current.selection.getSelected();
                    for (int i = 0; i < selected.size(); ++i) {
                        Keyframe first = selected.get(0);
                        Keyframe keyframe = selected.get(i);
                        this.renderPreviewKeyframe(context, hovered, (float)Math.round(this.keyframes.fromGraphX(context.mouseX)) + (keyframe.getTick() - first.getTick()), 0xFFFF33);
                    }
                } else {
                    List<Keyframe> selected;
                    float min = Float.MAX_VALUE;
                    for (UIKeyframeSheet sheet : sheets) {
                        selected = sheet.selection.getSelected();
                        for (Keyframe keyframe : selected) {
                            min = Math.min(min, keyframe.getTick());
                        }
                    }
                    for (UIKeyframeSheet sheet : sheets) {
                        selected = sheet.selection.getSelected();
                        for (int i = 0; i < selected.size(); ++i) {
                            Keyframe keyframe;
                            keyframe = selected.get(i);
                            this.renderPreviewKeyframe(context, sheet, (float)Math.round(this.keyframes.fromGraphX(context.mouseX)) + (keyframe.getTick() - min), 0xFFFF33);
                        }
                    }
                }
            }
        }
    }

    private void renderPreviewKeyframe(UIContext context, UIKeyframeSheet sheet, double tick, int color) {
        int x = this.keyframes.toGraphX(tick);
        int y = this.getDopeSheetY(sheet) + (int)this.trackHeight / 2;
        float a = (float)Math.sin((double)context.getTickTransition() / 2.0) * 0.1f + 0.5f;
        context.batcher.box(x - 3, y - 3, x + 3, y + 3, Colors.setA(color, a));
    }

    protected void renderGraph(UIContext context) {
        if (this.sheets.isEmpty()) {
            return;
        }
        this.dopeSheet.scrollSize = (int)this.trackHeight * this.sheets.size() + 25;
        Area area = this.keyframes.area;
        class_287 builder = class_289.method_1348().method_1349();
        Matrix4f matrix = context.batcher.getContext().method_51448().method_23760().method_23761();
        for (int i = 0; i < this.sheets.size(); ++i) {
            int j;
            Keyframe frame;
            int y = this.getDopeSheetY(i);
            if ((double)y + this.trackHeight < (double)area.y || y > area.ey()) continue;
            UIKeyframeSheet sheet = this.sheets.get(i);
            List keyframes = sheet.channel.getKeyframes();
            boolean hover = area.isInside(context) && context.mouseY >= y && (double)context.mouseY < (double)y + this.trackHeight;
            int my = y + (int)this.trackHeight / 2;
            int cc = Colors.setA(sheet.color, hover ? 1.0f : 0.45f);
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            context.batcher.fillRect(builder, matrix, area.x, my - 1, area.w, 2.0f, cc, cc, cc, cc);
            if (sheet.separator) {
                int c = Colors.setA(sheet.color, 0.0f);
                context.batcher.fillRect(builder, matrix, area.x, y, area.w, (int)this.trackHeight, c | 0x44000000, c | 0x44000000, c, c);
            }
            for (int j2 = 1; j2 < keyframes.size(); ++j2) {
                Keyframe previous = keyframes.get(j2 - 1);
                frame = keyframes.get(j2);
                int c = 0x44FFFF33;
                int xx = this.keyframes.toGraphX(previous.getTick());
                int xxx = this.keyframes.toGraphX(frame.getTick());
                if (previous.getFactory().compare(previous.getValue(), frame.getValue())) {
                    context.batcher.fillRect(builder, matrix, xx, my - 2, this.keyframes.toGraphX(frame.getTick()) - xx, 4.0f, c, c, c, c);
                }
                if (Math.abs(xxx - xx) >= 5) continue;
                c = -1996488909;
                context.batcher.fillRect(builder, matrix, xx - 2, my + 5, xxx - xx + 4, 2.0f, c, c, c, c);
            }
            int forcedIndex = 0;
            for (j = 0; j < keyframes.size(); ++j) {
                boolean toRemove;
                int x2;
                frame = keyframes.get(j);
                float tick = frame.getTick();
                int x1 = this.keyframes.toGraphX(tick);
                if (x1 != (x2 = this.keyframes.toGraphX(tick + frame.getDuration()))) {
                    int y1 = my - 8 + (forcedIndex % 2 == 1 ? -4 : 0);
                    int color = sheet.selection.has(j) ? -1 : Colors.setA(Colors.mulRGB(sheet.color, 0.9f), 0.75f);
                    context.batcher.fillRect(builder, matrix, x1, y1 - 2, 1.0f, 5.0f, color, color, color, color);
                    context.batcher.fillRect(builder, matrix, x2, y1 - 2, 1.0f, 5.0f, color, color, color, color);
                    context.batcher.fillRect(builder, matrix, x1 + 1, y1, x2 - x1, 1.0f, color, color, color, color);
                    ++forcedIndex;
                }
                boolean isPointHover = this.isNear(this.keyframes.toGraphX(frame.getTick()), my, context.mouseX, context.mouseY, Window.isAltPressed() && Window.isShiftPressed());
                boolean bl = toRemove = Window.isCtrlPressed() && isPointHover;
                if (this.keyframes.isSelecting()) {
                    isPointHover = isPointHover || this.keyframes.getGrabbingArea(context).isInside(x1, my);
                }
                int kc = frame.getColor() != null ? frame.getColor().getRGBColor() | 0xFF000000 : sheet.color;
                int c = (sheet.selection.has(j) || isPointHover ? -1 : kc) | 0xFF000000;
                if (toRemove) {
                    c = -52429;
                }
                int offset = toRemove ? 4 : 3;
                this.renderShape(frame, context, builder, matrix, x1, my, offset, c);
            }
            for (j = 0; j < keyframes.size(); ++j) {
                frame = keyframes.get(j);
                int c = sheet.selection.has(j) ? 35071 : 0;
                int mx = this.keyframes.toGraphX(frame.getTick());
                int mc = c | 0xFF000000;
                IKeyframeShapeRenderer shapeResult = this.renderShape(frame, context, builder, matrix, mx, my, 2, mc);
                shapeResult.renderKeyframeBackground(context, builder, matrix, mx, my, 2, mc);
            }
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34540);
            class_286.method_43433((class_287.class_7433)builder.method_1326());
            FontRenderer font = context.batcher.getFont();
            int lw = font.getWidth(sheet.title.get());
            context.batcher.gradientHBox(area.ex() - lw - 10, y, area.ex(), y + (int)this.trackHeight, sheet.color, sheet.color | (hover ? -1157627904 : 0x44000000));
            if (hover) {
                context.batcher.textShadow(sheet.title.get(), area.ex() - lw - 5, my - font.getHeight() / 2);
            } else {
                context.batcher.text(sheet.title.get(), area.ex() - lw - 5, my - font.getHeight() / 2, -1996488705);
            }
            Icon icon = sheet.getIcon();
            if (icon == null || !(this.trackHeight >= 12.0)) continue;
            context.batcher.box(area.x, y, area.x + 6, y + (int)this.trackHeight, -1157627904);
            context.batcher.gradientHBox(area.x + 6, y, area.x + 4 + icon.w, y + (int)this.trackHeight, -1157627904, 0);
            context.batcher.icon(icon, area.x + 2, my - icon.h / 2);
        }
    }

    protected IKeyframeShapeRenderer renderShape(Keyframe frame, UIContext context, class_287 builder, Matrix4f matrix, int x, int y, int offset, int c) {
        KeyframeShape keyframeShape = frame.getShape();
        IKeyframeShapeRenderer shape = KeyframeShapeRenderers.SHAPES.get((Object)keyframeShape);
        shape.renderKeyframe(context, builder, matrix, x, y, offset, c);
        return shape;
    }

    @Override
    public void postRender(UIContext context) {
        this.dopeSheet.renderScrollbar(context.batcher);
    }

    @Override
    public void saveState(MapType extra) {
        extra.putDouble("track_height", this.trackHeight);
        extra.putDouble("scroll", this.dopeSheet.getScroll());
    }

    @Override
    public void restoreState(MapType extra) {
        this.setTrackHeight(extra.getDouble("track_height"));
        this.dopeSheet.setScroll(extra.getDouble("scroll"));
    }
}

