/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.overlay;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.audio.AudioReader;
import mchorse.bbs_mod.audio.ColorCode;
import mchorse.bbs_mod.audio.SoundManager;
import mchorse.bbs_mod.audio.SoundPlayer;
import mchorse.bbs_mod.audio.Wave;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.screenplay.UIAudioPlayer;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIStringOverlayPanel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UISoundOverlayPanel
extends UIStringOverlayPanel {
    public UIAudioPlayer player;

    private static Set<String> getSoundEvents() {
        HashSet<String> locations = new HashSet<String>();
        for (Link link : BBSMod.getProvider().getLinksFromPath(Link.assets("audio"))) {
            String pathLower = link.path.toLowerCase();
            boolean supportedExtension = pathLower.endsWith(".wav") || pathLower.endsWith(".ogg");
            if (!supportedExtension) continue;
            locations.add(link.toString());
        }
        return locations;
    }

    public UISoundOverlayPanel(Consumer<Link> callback) {
        super(UIKeys.OVERLAYS_SOUNDS_MAIN, UISoundOverlayPanel.getSoundEvents(), null);
        this.callback(str -> {
            if (callback != null) {
                Link link = Link.create(str);
                callback.accept(link);
                try {
                    SoundManager sounds = BBSModClient.getSounds();
                    Wave wave = AudioReader.read(BBSMod.getProvider(), link);
                    SoundPlayer player = this.player.getPlayer();
                    if (player != null) {
                        player.stop();
                    }
                    List<ColorCode> colorCodes = sounds.readColorCodes(link);
                    if (wave.getBytesPerSample() > 2) {
                        wave = wave.convertTo16();
                    }
                    this.player.loadAudio(wave, colorCodes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.player = new UIAudioPlayer();
        this.content.add((IUIElement)this.player);
        this.player.relative(this.content).x(6).w(1.0f, -12).h(20);
        this.strings.y(20).h(1.0f, -20);
    }
}

