/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles.sections;

import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.particles.ParticleMaterial;
import mchorse.bbs_mod.particles.ParticleScheme;
import mchorse.bbs_mod.particles.components.appearance.ParticleComponentAppearanceBillboard;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UICirculate;
import mchorse.bbs_mod.ui.framework.elements.input.UITexturePicker;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.particles.UIParticleSchemePanel;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeSection;
import mchorse.bbs_mod.ui.utils.UI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIParticleSchemeGeneralSection
extends UIParticleSchemeSection {
    public UITextbox identifier = new UITextbox(100, str -> {
        this.scheme.identifier = str;
        this.editor.dirty();
    });
    public UIButton pick;
    public UICirculate material;

    public UIParticleSchemeGeneralSection(UIParticleSchemePanel parent) {
        super(parent);
        this.identifier.tooltip(UIKeys.SNOWSTORM_GENERAL_IDENTIFIER);
        this.pick = new UIButton(UIKeys.SNOWSTORM_GENERAL_PICK, b -> UITexturePicker.open(this.getContext(), this.scheme.texture, link -> {
            if (link == null) {
                link = ParticleScheme.DEFAULT_TEXTURE;
            }
            this.setTextureSize((Link)link);
            this.scheme.texture = link;
            this.editor.dirty();
        }));
        this.material = new UICirculate(b -> {
            this.scheme.material = ParticleMaterial.values()[this.material.getValue()];
            this.editor.dirty();
        });
        this.material.addLabel(UIKeys.SNOWSTORM_GENERAL_PARTICLES_OPAQUE);
        this.material.addLabel(UIKeys.SNOWSTORM_GENERAL_PARTICLES_ALPHA);
        this.material.addLabel(UIKeys.SNOWSTORM_GENERAL_PARTICLES_BLEND);
        this.fields.add(this.identifier, UI.row(5, 0, 20, this.pick, this.material));
    }

    private void setTextureSize(Link link) {
        ParticleComponentAppearanceBillboard component = this.scheme.get(ParticleComponentAppearanceBillboard.class);
        if (component == null) {
            return;
        }
        Texture texture = BBSModClient.getTextures().getTexture(link);
        component.textureWidth = texture.width;
        component.textureHeight = texture.height;
    }

    @Override
    public IKey getTitle() {
        return UIKeys.SNOWSTORM_GENERAL_TITLE;
    }

    @Override
    public void setScheme(ParticleScheme scheme) {
        super.setScheme(scheme);
        this.identifier.setText(scheme.identifier);
        this.material.setValue(scheme.material.ordinal());
    }
}

