/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.undo;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.utils.undo.IUndo;

public class CompoundUndo<T>
implements IUndo<T> {
    private List<IUndo<T>> undos = new ArrayList<IUndo<T>>();
    private boolean mergable = true;

    public CompoundUndo(List<IUndo<T>> undos) {
        this.undos.addAll(undos);
    }

    public CompoundUndo(IUndo<T> ... undos) {
        for (IUndo<T> undo : undos) {
            if (undo == null) continue;
            this.undos.add(undo);
        }
    }

    public List<IUndo<T>> getUndos() {
        return this.undos;
    }

    public IUndo<T> getFirst(Class<? extends IUndo<T>> clazz) {
        for (int i = 0; i < this.undos.size(); ++i) {
            IUndo<T> undo = this.undos.get(i);
            if (!clazz.isAssignableFrom(undo.getClass())) continue;
            return undo;
        }
        return null;
    }

    public IUndo<T> getLast(Class<? extends IUndo<T>> clazz) {
        for (int i = this.undos.size() - 1; i >= 0; --i) {
            IUndo<T> undo = this.undos.get(i);
            if (!clazz.isAssignableFrom(undo.getClass())) continue;
            return undo;
        }
        return null;
    }

    public boolean has(Class<? extends IUndo<T>> clazz) {
        for (IUndo<T> undo : this.undos) {
            if (!clazz.isAssignableFrom(undo.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IUndo<T> noMerging() {
        this.mergable = false;
        return this;
    }

    @Override
    public boolean isMergeable(IUndo<T> undo) {
        if (this.mergable && undo instanceof CompoundUndo && ((CompoundUndo)undo).undos.size() == this.undos.size()) {
            CompoundUndo compound = (CompoundUndo)undo;
            for (int i = 0; i < this.undos.size(); ++i) {
                if (this.undos.get(i).isMergeable(compound.undos.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void merge(IUndo<T> undo) {
        CompoundUndo theUndo = (CompoundUndo)undo;
        int c = this.undos.size();
        for (int i = 0; i < c; ++i) {
            IUndo<T> otherChildUndo = theUndo.undos.get(i);
            IUndo<T> myUndo = this.undos.get(i);
            if (!myUndo.isMergeable(otherChildUndo)) continue;
            myUndo.merge(otherChildUndo);
        }
    }

    @Override
    public void undo(T context) {
        for (int i = this.undos.size() - 1; i >= 0; --i) {
            this.undos.get(i).undo(context);
        }
    }

    @Override
    public void redo(T context) {
        for (IUndo<T> undo : this.undos) {
            undo.redo(context);
        }
    }
}

