/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.audio;

import mchorse.bbs_mod.audio.SoundBuffer;
import mchorse.bbs_mod.utils.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3f;
import org.lwjgl.openal.AL10;

@Environment(value=EnvType.CLIENT)
public class SoundPlayer {
    private int source;
    private SoundBuffer buffer;
    private boolean unique;

    public SoundPlayer(SoundBuffer buffer) {
        this.buffer = buffer;
        this.source = AL10.alGenSources();
        AL10.alSourcei((int)this.source, (int)4105, (int)buffer.getBuffer());
        AL10.alSourcef((int)this.source, (int)4131, (float)60.0f);
        this.setRelative(false);
    }

    public SoundPlayer unique() {
        this.unique = true;
        return this;
    }

    public int getSource() {
        return this.source;
    }

    public SoundBuffer getBuffer() {
        return this.buffer;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean canBeRemoved() {
        return !this.unique && this.isStopped();
    }

    public void setVolume(float volume) {
        AL10.alSourcef((int)this.source, (int)4106, (float)volume);
    }

    public void setPitch(float pitch) {
        AL10.alSourcef((int)this.source, (int)4099, (float)pitch);
    }

    public void setRelative(boolean relative) {
        AL10.alSourcei((int)this.source, (int)514, (int)(relative ? 1 : 0));
    }

    public void setLooping(boolean looping) {
        AL10.alSourcei((int)this.source, (int)4103, (int)(looping ? 1 : 0));
    }

    public void setPosition(Vector3f vector) {
        this.setPosition(vector.x, vector.y, vector.z);
    }

    public void setPosition(float x, float y, float z) {
        AL10.alSource3f((int)this.source, (int)4100, (float)x, (float)y, (float)z);
    }

    public void setVelocity(Vector3f vector) {
        this.setVelocity(vector.x, vector.y, vector.z);
    }

    public void setVelocity(float x, float y, float z) {
        AL10.alSource3f((int)this.source, (int)4102, (float)x, (float)y, (float)z);
    }

    public void play() {
        AL10.alSourcePlay((int)this.source);
    }

    public void pause() {
        AL10.alSourcePause((int)this.source);
    }

    public void stop() {
        AL10.alSourceStop((int)this.source);
    }

    public int getSourceState() {
        return AL10.alGetSourcei((int)this.source, (int)4112);
    }

    public boolean isPlaying() {
        return this.getSourceState() == 4114;
    }

    public boolean isPaused() {
        return this.getSourceState() == 4115;
    }

    public boolean isStopped() {
        if (this.source == -1) {
            return true;
        }
        int state = this.getSourceState();
        return state == 4116 || state == 4113;
    }

    public float getPlaybackPosition() {
        return AL10.alGetSourcef((int)this.source, (int)4132);
    }

    public void setPlaybackPosition(float seconds) {
        seconds = MathUtils.clamp(seconds, 0.0f, this.buffer.getDuration());
        AL10.alSourcef((int)this.source, (int)4132, (float)seconds);
    }

    public void delete() {
        AL10.alDeleteSources((int)this.source);
        this.source = -1;
        this.buffer = null;
    }
}

