/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.audio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.audio.wav.WaveCue;
import mchorse.bbs_mod.audio.wav.WaveList;
import mchorse.bbs_mod.utils.MathUtils;
import org.lwjgl.system.MemoryUtil;

public class Wave {
    public int audioFormat;
    public int numChannels;
    public int sampleRate;
    public int byteRate;
    public int blockAlign;
    public int bitsPerSample;
    public byte[] data;
    public List<WaveList> lists = new ArrayList<WaveList>();
    public List<WaveCue> cues = new ArrayList<WaveCue>();

    public Wave(int audioFormat, int numChannels, int sampleRate, int bitsPerSample, byte[] data) {
        int bytesPerSample = bitsPerSample / 8;
        int byteRate = sampleRate * numChannels * bytesPerSample;
        int blockAlign = numChannels * bytesPerSample;
        this.audioFormat = audioFormat;
        this.numChannels = numChannels;
        this.sampleRate = sampleRate;
        this.byteRate = byteRate;
        this.blockAlign = blockAlign;
        this.bitsPerSample = bitsPerSample;
        this.data = data;
    }

    public Wave(int audioFormat, int numChannels, int sampleRate, int byteRate, int blockAlign, int bitsPerSample, byte[] data) {
        this.audioFormat = audioFormat;
        this.numChannels = numChannels;
        this.sampleRate = sampleRate;
        this.byteRate = byteRate;
        this.blockAlign = blockAlign;
        this.bitsPerSample = bitsPerSample;
        this.data = data;
    }

    public int getBytesPerSample() {
        return this.bitsPerSample / 8;
    }

    public float getDuration() {
        return (float)this.data.length / (float)this.numChannels / (float)this.getBytesPerSample() / (float)this.sampleRate;
    }

    public int getALFormat() {
        int bytes = this.getBytesPerSample();
        if (bytes == 1) {
            if (this.numChannels == 2) {
                return 4354;
            }
            if (this.numChannels == 1) {
                return 4352;
            }
        } else if (bytes == 2) {
            if (this.numChannels == 2) {
                return 4355;
            }
            if (this.numChannels == 1) {
                return 4353;
            }
        }
        throw new IllegalStateException("Current WAV file has unusual configuration... channels: " + this.numChannels + ", BPS: " + bytes);
    }

    public int getScanRegion(float pixelsPerSecond) {
        return (int)((float)this.sampleRate / pixelsPerSecond) * this.getBytesPerSample() * this.numChannels;
    }

    public Wave convertTo16() {
        int bytes = 2;
        int c = this.data.length / this.numChannels / this.getBytesPerSample();
        int byteRate = this.sampleRate * this.numChannels * 2;
        byte[] data = new byte[c * this.numChannels * 2];
        boolean isFloat = this.getBytesPerSample() == 4;
        Wave wave = new Wave(this.audioFormat, this.numChannels, this.sampleRate, byteRate, 2 * this.numChannels, 16, data);
        ByteBuffer sample = MemoryUtil.memAlloc((int)4);
        ByteBuffer dataBuffer = MemoryUtil.memAlloc((int)data.length);
        for (int i = 0; i < c * this.numChannels; ++i) {
            double scaledValue;
            sample.clear();
            for (int j = 0; j < this.getBytesPerSample(); ++j) {
                sample.put(this.data[i * this.getBytesPerSample() + j]);
            }
            if (isFloat) {
                sample.flip();
                float floatValue = sample.getFloat();
                floatValue = Math.max(-1.0f, Math.min(1.0f, floatValue));
                dataBuffer.putShort((short)(floatValue * 32767.0f));
                continue;
            }
            sample.put((byte)0);
            sample.flip();
            int intValue = sample.getInt();
            if (this.bitsPerSample == 24) {
                scaledValue = (double)intValue / 8388608.0 * 32767.0;
                dataBuffer.putShort((short)Math.max(-32768L, Math.min(32767L, (long)scaledValue)));
                continue;
            }
            if (this.bitsPerSample == 32) {
                scaledValue = (double)intValue / 2.147483648E9 * 32767.0;
                dataBuffer.putShort((short)Math.max(-32768L, Math.min(32767L, (long)scaledValue)));
                continue;
            }
            double maxOriginalValue = Math.pow(2.0, this.bitsPerSample - 1) - 1.0;
            double scaledValue2 = (double)intValue / maxOriginalValue * 32767.0;
            dataBuffer.putShort((short)Math.max(-32768L, Math.min(32767L, (long)scaledValue2)));
        }
        dataBuffer.flip();
        dataBuffer.get(data);
        MemoryUtil.memFree((Buffer)sample);
        MemoryUtil.memFree((Buffer)dataBuffer);
        wave.lists = this.lists;
        wave.cues = this.cues;
        return wave;
    }

    public float[] getCues() {
        float[] cues = new float[this.cues.size()];
        int i = 0;
        for (WaveCue cue : this.cues) {
            cues[i] = (float)cue.position / (float)this.sampleRate;
            ++i;
        }
        return cues;
    }

    public void add(ByteBuffer buffer, Wave wave, float offset, float shift, float duration) {
        int waveStart = this.truncate((int)(shift * (float)wave.byteRate));
        int start = this.truncate((int)(offset * (float)this.byteRate));
        int end = this.truncate((int)((offset + duration) * (float)this.byteRate));
        end = this.truncate(Math.min(end, this.data.length));
        float ratio = (float)wave.sampleRate / (float)this.sampleRate;
        boolean useLinearInterpolation = Math.abs(ratio - 1.0f) > 0.01f;
        int targetStep = this.numChannels * this.getBytesPerSample();
        int sourceStep = wave.numChannels * wave.getBytesPerSample();
        int i = 0;
        while (start + i < end) {
            float mixedFloat;
            int waveShort;
            int requiredSourceBytes;
            float sampleIndex = (float)(i / targetStep) * ratio;
            float exactPos = (float)waveStart + sampleIndex * (float)sourceStep;
            int a = this.truncate((int)exactPos);
            int b = start + i;
            int n = requiredSourceBytes = useLinearInterpolation ? sourceStep * 2 : sourceStep;
            if (a + requiredSourceBytes - 1 >= wave.data.length || b + targetStep - 1 >= this.data.length) break;
            if (useLinearInterpolation) {
                waveShort = this.getLinearInterpolatedSample(wave, exactPos);
            } else if (wave.numChannels == 2 && this.numChannels == 1) {
                buffer.position(0);
                buffer.put(wave.data[a]);
                buffer.put(wave.data[a + 1]);
                short leftSample = buffer.getShort(0);
                buffer.position(0);
                buffer.put(wave.data[a + 2]);
                buffer.put(wave.data[a + 3]);
                short rightSample = buffer.getShort(0);
                waveShort = (leftSample + rightSample) / 2;
            } else {
                buffer.position(0);
                buffer.put(wave.data[a]);
                buffer.put(wave.data[a + 1]);
                waveShort = buffer.getShort(0);
            }
            buffer.position(0);
            buffer.put(this.data[b]);
            buffer.put(this.data[b + 1]);
            short bytesShort = buffer.getShort(0);
            float waveFloat = (float)waveShort / 32767.0f;
            float bytesFloat = (float)bytesShort / 32767.0f;
            float sum = waveFloat + bytesFloat;
            if (sum > 1.0f || sum < -1.0f) {
                float absSum = Math.abs(sum);
                float normalizationFactor = 1.0f / absSum;
                mixedFloat = sum * normalizationFactor * 0.95f;
            } else {
                mixedFloat = sum;
            }
            int finalShort = (int)(mixedFloat * 32767.0f);
            buffer.putShort(0, (short)MathUtils.clamp(finalShort, Short.MIN_VALUE, Short.MAX_VALUE));
            this.data[b + 1] = buffer.get(1);
            this.data[b] = buffer.get(0);
            i += targetStep;
        }
    }

    private int getLinearInterpolatedSample(Wave wave, float exactPos) {
        short sample2;
        short sample1;
        int bytesPerSample = wave.getBytesPerSample();
        int sourceStep = wave.numChannels * bytesPerSample;
        int baseIndex = this.truncate((int)exactPos);
        float fraction = (exactPos - (float)baseIndex) / (float)sourceStep;
        int requiredBytes = sourceStep * 2;
        if (baseIndex + requiredBytes - 1 >= wave.data.length || baseIndex < 0) {
            return 0;
        }
        ByteBuffer buffer = MemoryUtil.memAlloc((int)4);
        buffer.position(0);
        if (wave.numChannels == 2 && this.numChannels == 1) {
            buffer.put(wave.data[baseIndex]);
            buffer.put(wave.data[baseIndex + 1]);
            short leftSample1 = buffer.getShort(0);
            buffer.position(0);
            buffer.put(wave.data[baseIndex + 2]);
            buffer.put(wave.data[baseIndex + 3]);
            short rightSample1 = buffer.getShort(0);
            sample1 = (short)((leftSample1 + rightSample1) / 2);
        } else {
            buffer.put(wave.data[baseIndex]);
            buffer.put(wave.data[baseIndex + 1]);
            sample1 = buffer.getShort(0);
        }
        buffer.position(0);
        int nextSampleIndex = baseIndex + sourceStep;
        if (wave.numChannels == 2 && this.numChannels == 1) {
            buffer.put(wave.data[nextSampleIndex]);
            buffer.put(wave.data[nextSampleIndex + 1]);
            short leftSample2 = buffer.getShort(0);
            buffer.position(0);
            buffer.put(wave.data[nextSampleIndex + 2]);
            buffer.put(wave.data[nextSampleIndex + 3]);
            short rightSample2 = buffer.getShort(0);
            sample2 = (short)((leftSample2 + rightSample2) / 2);
        } else {
            buffer.put(wave.data[nextSampleIndex]);
            buffer.put(wave.data[nextSampleIndex + 1]);
            sample2 = buffer.getShort(0);
        }
        MemoryUtil.memFree((Buffer)buffer);
        float interpolated = (float)sample1 + (float)(sample2 - sample1) * fraction;
        return (int)MathUtils.clamp(interpolated, -32768.0f, 32767.0f);
    }

    private int truncate(int offset) {
        return offset - offset % 2;
    }
}

