/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mchorse.bbs_mod.bobj.BOBJBone;
import mchorse.bbs_mod.cubic.IModel;
import mchorse.bbs_mod.cubic.IModelInstance;
import mchorse.bbs_mod.cubic.data.animation.Animations;
import mchorse.bbs_mod.cubic.data.model.Model;
import mchorse.bbs_mod.cubic.data.model.ModelGroup;
import mchorse.bbs_mod.cubic.model.ArmorSlot;
import mchorse.bbs_mod.cubic.model.ArmorType;
import mchorse.bbs_mod.cubic.model.bobj.BOBJModel;
import mchorse.bbs_mod.cubic.render.CubicCubeRenderer;
import mchorse.bbs_mod.cubic.render.CubicMatrixRenderer;
import mchorse.bbs_mod.cubic.render.CubicRenderer;
import mchorse.bbs_mod.cubic.render.CubicVAOBuilderRenderer;
import mchorse.bbs_mod.cubic.render.CubicVAORenderer;
import mchorse.bbs_mod.cubic.render.vao.BOBJModelVAO;
import mchorse.bbs_mod.cubic.render.vao.ModelVAO;
import mchorse.bbs_mod.data.DataStorageUtils;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.obj.shapes.ShapeKeys;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.elements.utils.StencilMap;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.pose.Pose;
import mchorse.bbs_mod.utils.resources.LinkUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ModelInstance
implements IModelInstance {
    public final String id;
    public IModel model;
    public Animations animations;
    public Link texture;
    public String poseGroup;
    public boolean procedural;
    public boolean culling = true;
    public boolean onCpu;
    public String anchorGroup = "";
    public Vector3f scale = new Vector3f(1.0f);
    public float uiScale = 1.0f;
    public Pose sneakingPose = new Pose();
    public List<ArmorSlot> itemsMain = new ArrayList<ArmorSlot>();
    public List<ArmorSlot> itemsOff = new ArrayList<ArmorSlot>();
    public Map<String, String> flippedParts = new HashMap<String, String>();
    public Map<ArmorType, ArmorSlot> armorSlots = new HashMap<ArmorType, ArmorSlot>();
    public ArmorSlot fpMain;
    public ArmorSlot fpOffhand;
    private Map<ModelGroup, ModelVAO> vaos = new HashMap<ModelGroup, ModelVAO>();

    public ModelInstance(String id, IModel model, Animations animations, Link texture) {
        this.id = id;
        this.model = model;
        this.animations = animations;
        this.texture = texture;
        this.poseGroup = id;
    }

    @Override
    public IModel getModel() {
        return this.model;
    }

    @Override
    public Pose getSneakingPose() {
        return this.sneakingPose;
    }

    @Override
    public Animations getAnimations() {
        return this.animations;
    }

    public Map<ModelGroup, ModelVAO> getVaos() {
        return this.vaos;
    }

    public String getAnchor() {
        String anchor = this.model.getAnchor();
        if (this.anchorGroup.isEmpty() && !anchor.isEmpty()) {
            return anchor;
        }
        return this.anchorGroup;
    }

    public void applyConfig(MapType config) {
        MapType map;
        ArmorSlot slot;
        ListType list;
        if (config == null) {
            return;
        }
        this.procedural = config.getBool("procedural", this.procedural);
        this.culling = config.getBool("culling", this.culling);
        this.onCpu = config.getBool("on_cpu", this.onCpu);
        this.poseGroup = config.getString("pose_group", this.poseGroup);
        if (config.has("texture")) {
            this.texture = LinkUtils.create(config.get("texture"));
        }
        if (config.has("items_main")) {
            list = config.get("items_main").asList();
            for (BaseType type : list) {
                slot = new ArmorSlot();
                slot.fromData(type);
                this.itemsMain.add(slot);
            }
        }
        if (config.has("items_off")) {
            list = config.get("items_off").asList();
            for (BaseType type : list) {
                slot = new ArmorSlot();
                slot.fromData(type);
                this.itemsOff.add(slot);
            }
        }
        if (config.has("ui_scale")) {
            this.uiScale = config.getFloat("ui_scale");
        }
        if (config.has("scale")) {
            this.scale = DataStorageUtils.vector3fFromData(config.getList("scale"), new Vector3f(1.0f));
        }
        if (config.has("sneaking_pose", 0)) {
            this.sneakingPose = new Pose();
            this.sneakingPose.fromData(config.getMap("sneaking_pose"));
        }
        if (config.has("anchor")) {
            this.anchorGroup = config.getString("anchor");
        }
        if (config.has("flipped_parts")) {
            map = config.getMap("flipped_parts");
            for (String key : map.keys()) {
                String string = map.getString(key);
                if (string.trim().isEmpty()) continue;
                this.flippedParts.put(key, string);
            }
        }
        if (config.has("armor_slots")) {
            map = config.getMap("armor_slots");
            for (String key : map.keys()) {
                try {
                    ArmorType type = ArmorType.valueOf(key.toUpperCase());
                    ArmorSlot slot2 = new ArmorSlot();
                    slot2.fromData(map.getMap(key));
                    this.armorSlots.put(type, slot2);
                }
                catch (Exception exception) {}
            }
        }
        if (config.has("fp_main")) {
            this.fpMain = new ArmorSlot();
            this.fpMain.fromData(config.get("fp_main"));
        }
        if (config.has("fp_offhand")) {
            this.fpOffhand = new ArmorSlot();
            this.fpOffhand.fromData(config.get("fp_offhand"));
        }
    }

    public void setup() {
        IModel model;
        IModel iModel = this.model;
        if (iModel instanceof BOBJModel) {
            model = (BOBJModel)iModel;
            class_310.method_1551().execute(((BOBJModel)model)::setup);
        }
        if (!this.model.getShapeKeys().isEmpty()) {
            return;
        }
        iModel = this.model;
        if (iModel instanceof Model) {
            model = (Model)iModel;
            if (!this.onCpu) {
                class_310.method_1551().execute(() -> this.lambda$setup$0((Model)model));
            }
        }
    }

    public boolean isVAORendered() {
        return !this.vaos.isEmpty() || this.model instanceof BOBJModel;
    }

    public void delete() {
        for (ModelVAO value : this.vaos.values()) {
            value.delete();
        }
        this.vaos.clear();
    }

    public void fillStencilMap(StencilMap stencilMap, ModelForm form) {
        block3: {
            Object object;
            block2: {
                object = this.model;
                if (!(object instanceof Model)) break block2;
                Model model = (Model)object;
                for (ModelGroup group : model.getOrderedGroups()) {
                    stencilMap.addPicking(form, group.id);
                }
                break block3;
            }
            object = this.model;
            if (!(object instanceof BOBJModel)) break block3;
            BOBJModel model = (BOBJModel)object;
            for (BOBJBone orderedBone : model.getArmature().orderedBones) {
                stencilMap.addPicking(form, orderedBone.name);
            }
        }
    }

    public void captureMatrices(Map<String, Matrix4f> bones, String target) {
        block3: {
            Object object;
            block2: {
                object = this.model;
                if (!(object instanceof Model)) break block2;
                Model model = (Model)object;
                class_4587 stack = new class_4587();
                CubicMatrixRenderer renderer = new CubicMatrixRenderer(model, target);
                CubicRenderer.processRenderModel(renderer, null, stack, model);
                for (ModelGroup group : model.getAllGroups()) {
                    Matrix4f matrix = new Matrix4f((Matrix4fc)renderer.matrices.get(group.index));
                    matrix.translate(group.initial.translate.x / 16.0f, group.initial.translate.y / 16.0f, group.initial.translate.z / 16.0f);
                    matrix.rotateY((float)Math.PI);
                    bones.put(group.id, matrix);
                }
                break block3;
            }
            object = this.model;
            if (!(object instanceof BOBJModel)) break block3;
            BOBJModel model = (BOBJModel)object;
            model.getArmature().setupMatrices();
            for (BOBJBone orderedBone : model.getArmature().orderedBones) {
                Matrix4f value = new Matrix4f();
                value.rotateY((float)Math.PI).mul((Matrix4fc)orderedBone.mat);
                bones.put(orderedBone.name, value);
            }
        }
    }

    public void render(class_4587 stack, Supplier<class_5944> program, Color color, int light, int overlay, StencilMap stencilMap, ShapeKeys keys) {
        IModel iModel = this.model;
        if (iModel instanceof Model) {
            Model model = (Model)iModel;
            boolean isVao = this.isVAORendered();
            CubicCubeRenderer renderProcessor = isVao ? new CubicVAORenderer(program.get(), this, light, overlay, stencilMap, keys) : new CubicCubeRenderer(light, overlay, stencilMap, keys);
            renderProcessor.setColor(color.r, color.g, color.b, color.a);
            if (isVao) {
                CubicRenderer.processRenderModel(renderProcessor, null, stack, model);
            } else {
                RenderSystem.setShader(program);
                class_287 builder = class_289.method_1348().method_1349();
                builder.method_1328(class_293.class_5596.field_27379, class_290.field_1580);
                CubicRenderer.processRenderModel(renderProcessor, builder, stack, model);
                class_286.method_43433((class_287.class_7433)builder.method_1326());
            }
        } else {
            BOBJModel model;
            BOBJModelVAO vao;
            IModel isVao = this.model;
            if (isVao instanceof BOBJModel && (vao = (model = (BOBJModel)isVao).getVao()) != null) {
                stack.method_22903();
                stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                vao.armature.setupMatrices();
                vao.updateMesh(stencilMap);
                vao.render(program.get(), stack, color.r, color.g, color.b, color.a, stencilMap, light, overlay);
                stack.method_22909();
            }
        }
    }

    private /* synthetic */ void lambda$setup$0(Model model) {
        CubicRenderer.processRenderModel(new CubicVAOBuilderRenderer(this.vaos), null, new class_4587(), model);
    }
}

