/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mchorse.bbs_mod.data.storage.DataStorage;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ByteType;
import mchorse.bbs_mod.data.types.DoubleType;
import mchorse.bbs_mod.data.types.FloatType;
import mchorse.bbs_mod.data.types.IntType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.LongType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.data.types.ShortType;
import mchorse.bbs_mod.data.types.StringType;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.joml.Matrix3f;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class DataStorageUtils {
    private static final byte[] EMPTY = new byte[0];

    public static byte[] writeToBytes(BaseType type) {
        if (type == null) {
            return EMPTY;
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataStorage.writeToStream(stream, type);
            return stream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY;
        }
    }

    public static BaseType readFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            return DataStorage.readFromStream(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeToPacket(class_2540 packet, BaseType type) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataStorage.writeToStream(stream, type);
            packet.method_10813(stream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BaseType readFromPacket(class_2540 packet) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(packet.method_10795());
            return DataStorage.readFromStream(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class_2520 toNbt(BaseType type) {
        if (type instanceof ByteType) {
            ByteType byteType = (ByteType)type;
            return class_2481.method_23233((byte)byteType.value);
        }
        if (type instanceof DoubleType) {
            DoubleType doubleType = (DoubleType)type;
            return class_2489.method_23241((double)doubleType.value);
        }
        if (type instanceof FloatType) {
            FloatType floatType = (FloatType)type;
            return class_2494.method_23244((float)floatType.value);
        }
        if (type instanceof IntType) {
            IntType intType = (IntType)type;
            return class_2497.method_23247((int)intType.value);
        }
        if (type instanceof LongType) {
            LongType longType = (LongType)type;
            return class_2503.method_23251((long)longType.value);
        }
        if (type instanceof ShortType) {
            ShortType shortType = (ShortType)type;
            return class_2516.method_23254((short)shortType.value);
        }
        if (type instanceof StringType) {
            StringType stringType = (StringType)type;
            return class_2519.method_23256((String)stringType.value);
        }
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            class_2499 list = new class_2499();
            for (BaseType baseType : listType) {
                list.add((Object)DataStorageUtils.toNbt(baseType));
            }
            return list;
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            class_2487 compound = new class_2487();
            for (String key : mapType.keys()) {
                compound.method_10566(key, DataStorageUtils.toNbt(mapType.get(key)));
            }
            return compound;
        }
        return null;
    }

    public static BaseType fromNbt(class_2520 element) {
        if (element instanceof class_2481) {
            class_2481 nbtByte = (class_2481)element;
            return new ByteType(nbtByte.method_10698());
        }
        if (element instanceof class_2489) {
            class_2489 nbtDouble = (class_2489)element;
            return new DoubleType(nbtDouble.method_10697());
        }
        if (element instanceof class_2494) {
            class_2494 nbtFloat = (class_2494)element;
            return new FloatType(nbtFloat.method_10700());
        }
        if (element instanceof class_2497) {
            class_2497 nbtInt = (class_2497)element;
            return new IntType(nbtInt.method_10701());
        }
        if (element instanceof class_2503) {
            class_2503 nbtLong = (class_2503)element;
            return new LongType(nbtLong.method_10699());
        }
        if (element instanceof class_2516) {
            class_2516 nbtShort = (class_2516)element;
            return new ShortType(nbtShort.method_10696());
        }
        if (element instanceof class_2519) {
            class_2519 nbtString = (class_2519)element;
            return new StringType(nbtString.method_10714());
        }
        if (element instanceof class_2499) {
            class_2499 nbtList = (class_2499)element;
            ListType list = new ListType();
            for (class_2520 nbtElement : nbtList) {
                list.add(DataStorageUtils.fromNbt(nbtElement));
            }
            return list;
        }
        if (element instanceof class_2487) {
            class_2487 nbtCompound = (class_2487)element;
            MapType map = new MapType();
            for (String key : nbtCompound.method_10541()) {
                map.put(key, DataStorageUtils.fromNbt(nbtCompound.method_10580(key)));
            }
            return map;
        }
        return null;
    }

    public static void writeToNbtCompound(class_2487 compound, String key, BaseType data) {
        compound.method_10566(key, DataStorageUtils.toNbt(data));
    }

    public static BaseType readFromNbtCompound(class_2487 compound, String key) {
        BaseType baseType = DataStorageUtils.fromNbt(compound.method_10580(key));
        if (baseType != null) {
            return baseType;
        }
        return null;
    }

    public static ListType vector2iToData(Vector2i vector) {
        ListType list = new ListType();
        list.addInt(vector.x);
        list.addInt(vector.y);
        return list;
    }

    public static Vector2i vector2iFromData(ListType element) {
        return DataStorageUtils.vector2iFromData(element, new Vector2i());
    }

    public static Vector2i vector2iFromData(ListType element, Vector2i defaultValue) {
        if (element != null && element.size() >= 2) {
            return new Vector2i(element.getInt(0), element.getInt(1));
        }
        return defaultValue;
    }

    public static ListType vector3fToData(Vector3f vector) {
        ListType list = new ListType();
        list.addFloat(vector.x);
        list.addFloat(vector.y);
        list.addFloat(vector.z);
        return list;
    }

    public static Vector3f vector3fFromData(ListType element) {
        return DataStorageUtils.vector3fFromData(element, new Vector3f());
    }

    public static Vector3f vector3fFromData(ListType element, Vector3f defaultValue) {
        if (element != null && element.size() >= 3) {
            return new Vector3f(element.getFloat(0), element.getFloat(1), element.getFloat(2));
        }
        return defaultValue;
    }

    public static ListType vector3dToData(Vector3d vector) {
        ListType list = new ListType();
        list.addDouble(vector.x);
        list.addDouble(vector.y);
        list.addDouble(vector.z);
        return list;
    }

    public static Vector3d vector3dFromData(ListType element) {
        return DataStorageUtils.vector3dFromData(element, new Vector3d());
    }

    public static Vector3d vector3dFromData(ListType element, Vector3d defaultValue) {
        if (element != null && element.size() >= 3) {
            return new Vector3d(element.getDouble(0), element.getDouble(1), element.getDouble(2));
        }
        return defaultValue;
    }

    public static ListType vector4fToData(Vector4f vector) {
        ListType list = new ListType();
        list.addFloat(vector.x);
        list.addFloat(vector.y);
        list.addFloat(vector.z);
        list.addFloat(vector.w);
        return list;
    }

    public static Vector4f vector4fFromData(ListType element) {
        return DataStorageUtils.vector4fFromData(element, new Vector4f());
    }

    public static Vector4f vector4fFromData(ListType element, Vector4f defaultValue) {
        if (element != null && element.size() >= 4) {
            return new Vector4f(element.getFloat(0), element.getFloat(1), element.getFloat(2), element.getFloat(3));
        }
        return defaultValue;
    }

    public static ListType matrix3fToData(Matrix3f matrix) {
        ListType list = new ListType();
        list.addFloat(matrix.m00);
        list.addFloat(matrix.m01);
        list.addFloat(matrix.m02);
        list.addFloat(matrix.m10);
        list.addFloat(matrix.m11);
        list.addFloat(matrix.m12);
        list.addFloat(matrix.m20);
        list.addFloat(matrix.m21);
        list.addFloat(matrix.m22);
        return list;
    }

    public static Matrix3f matrix3fFromData(ListType element) {
        return DataStorageUtils.matrix3fFromData(element, new Matrix3f());
    }

    public static Matrix3f matrix3fFromData(ListType element, Matrix3f defaultValue) {
        if (element != null && element.size() >= 9) {
            return new Matrix3f(element.getFloat(0), element.getFloat(1), element.getFloat(2), element.getFloat(3), element.getFloat(4), element.getFloat(5), element.getFloat(6), element.getFloat(7), element.getFloat(8));
        }
        return defaultValue;
    }

    public static ListType stringListToData(Collection<String> strings) {
        ListType list = new ListType();
        for (String string : strings) {
            list.addString(string);
        }
        return list;
    }

    public static List<String> stringListFromData(BaseType type) {
        ArrayList<String> strings = new ArrayList<String>();
        if (type.isList()) {
            for (BaseType baseType : type.asList()) {
                if (!baseType.isString()) continue;
                strings.add(baseType.asString());
            }
        }
        return strings;
    }

    public static ListType intListToData(Collection<Integer> ints) {
        ListType list = new ListType();
        for (Integer i : ints) {
            list.addInt(i);
        }
        return list;
    }

    public static List<Integer> intListFromData(BaseType type) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        if (type.isList()) {
            for (BaseType baseType : type.asList()) {
                if (!baseType.isNumeric()) continue;
                ints.add(baseType.asNumeric().intValue());
            }
        }
        return ints;
    }
}

