/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.importers.types;

import java.io.File;
import java.io.FileInputStream;
import mchorse.bbs_mod.importers.ImporterContext;
import mchorse.bbs_mod.importers.ImporterUtils;
import mchorse.bbs_mod.importers.types.IImporter;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.math.Operation;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.utils.PNGEncoder;
import mchorse.bbs_mod.utils.resources.Pixels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class OldSkinImporter
implements IImporter {
    public static void convertSkin(File in, File out) throws Exception {
        try (FileInputStream stream = new FileInputStream(in);){
            Pixels source = Pixels.fromPNGStream(stream);
            float s = (float)source.width / 64.0f;
            Pixels destination = Pixels.fromSize((int)(64.0f * s), (int)(64.0f * s));
            OldSkinImporter.drawImage(source, destination, 0.0f, 0.0f, 64.0f, 32.0f, 0.0f, 0.0f, 64.0f, 32.0f, s);
            OldSkinImporter.drawImage(source, destination, 24.0f, 48.0f, 20.0f, 52.0f, 4.0f, 16.0f, 8.0f, 20.0f, s);
            OldSkinImporter.drawImage(source, destination, 28.0f, 48.0f, 24.0f, 52.0f, 8.0f, 16.0f, 12.0f, 20.0f, s);
            OldSkinImporter.drawImage(source, destination, 20.0f, 52.0f, 16.0f, 64.0f, 8.0f, 20.0f, 12.0f, 32.0f, s);
            OldSkinImporter.drawImage(source, destination, 24.0f, 52.0f, 20.0f, 64.0f, 4.0f, 20.0f, 8.0f, 32.0f, s);
            OldSkinImporter.drawImage(source, destination, 28.0f, 52.0f, 24.0f, 64.0f, 0.0f, 20.0f, 4.0f, 32.0f, s);
            OldSkinImporter.drawImage(source, destination, 32.0f, 52.0f, 28.0f, 64.0f, 12.0f, 20.0f, 16.0f, 32.0f, s);
            OldSkinImporter.drawImage(source, destination, 40.0f, 48.0f, 36.0f, 52.0f, 44.0f, 16.0f, 48.0f, 20.0f, s);
            OldSkinImporter.drawImage(source, destination, 44.0f, 48.0f, 40.0f, 52.0f, 48.0f, 16.0f, 52.0f, 20.0f, s);
            OldSkinImporter.drawImage(source, destination, 36.0f, 52.0f, 32.0f, 64.0f, 48.0f, 20.0f, 52.0f, 32.0f, s);
            OldSkinImporter.drawImage(source, destination, 40.0f, 52.0f, 36.0f, 64.0f, 44.0f, 20.0f, 48.0f, 32.0f, s);
            OldSkinImporter.drawImage(source, destination, 44.0f, 52.0f, 40.0f, 64.0f, 40.0f, 20.0f, 44.0f, 32.0f, s);
            OldSkinImporter.drawImage(source, destination, 48.0f, 52.0f, 44.0f, 64.0f, 52.0f, 20.0f, 56.0f, 32.0f, s);
            source.delete();
            PNGEncoder.writeToFile(destination, out);
            destination.delete();
        }
    }

    private static void drawImage(Pixels source, Pixels destination, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float scale) {
        destination.drawPixels(source, (int)(dx1 * scale), (int)(dy1 * scale), (int)(dx2 * scale), (int)(dy2 * scale), (int)(sx1 * scale), (int)(sy1 * scale), (int)(sx2 * scale), (int)(sy2 * scale));
    }

    @Override
    public IKey getName() {
        return UIKeys.IMPORTER_OLD_SKIN;
    }

    @Override
    public boolean canImport(ImporterContext context) {
        for (File file : context.files) {
            if (this.isOldSkin(file)) continue;
            return false;
        }
        return true;
    }

    private boolean isOldSkin(File file) {
        Vector2i vector2i = PNGEncoder.readSize(file);
        if (vector2i == null) {
            return false;
        }
        return Operation.equals(Math.abs((float)vector2i.x / (float)vector2i.y), 2.0);
    }

    @Override
    public void importFiles(ImporterContext context) {
        for (File file : context.files) {
            try {
                File destination = context.getDestination(this);
                OldSkinImporter.convertSkin(file, new File(destination, ImporterUtils.getName(destination, file.getName())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

