/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.audio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import mchorse.bbs_mod.audio.Wave;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class OpenALRecorder
implements Runnable {
    private static final int SAMPLE_RATE = 44100;
    private static final int FORMAT = 4353;
    private static final int BUFFER_SAMPLES = 1024;
    private long captureDevice;
    private ByteBuffer buffer;
    private boolean running = true;
    private Consumer<Wave> consumer;
    private long startTime;
    private float volume;

    public OpenALRecorder(Consumer<Wave> consumer) {
        this.consumer = consumer;
    }

    public void stop() {
        this.running = false;
    }

    public long getTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public float getVolume() {
        return this.volume;
    }

    public void init() {
        String defaultDeviceName = ALC11.alcGetString((long)0L, (int)785);
        if (defaultDeviceName == null) {
            throw new IllegalStateException("No capture devices available.");
        }
        this.captureDevice = ALC11.alcCaptureOpenDevice((CharSequence)defaultDeviceName, (int)44100, (int)4353, (int)1024);
        if (this.captureDevice == 0L) {
            throw new RuntimeException("Failed to open capture device.");
        }
        ALC11.alcCaptureStart((long)this.captureDevice);
        this.buffer = MemoryUtil.memAlloc((int)88200);
        this.startTime = System.currentTimeMillis();
    }

    public void pollAndProcess() {
        int available = ALC10.alcGetInteger((long)this.captureDevice, (int)786);
        if (available > 0) {
            if (this.buffer.position() + available * 2 > this.buffer.capacity()) {
                ByteBuffer newBuffer = MemoryUtil.memAlloc((int)(this.buffer.capacity() * 2));
                this.buffer.flip();
                newBuffer.put(this.buffer);
                MemoryUtil.memFree((Buffer)this.buffer);
                this.buffer = newBuffer;
            }
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(available * 2));
            ALC11.alcCaptureSamples((long)this.captureDevice, (ByteBuffer)buffer, (int)available);
            this.buffer.put(buffer);
            this.volume = 0.0f;
            for (int i = 0; i < available; ++i) {
                this.volume = Math.max(Math.abs((float)buffer.getShort(0) / 65535.0f), this.volume);
            }
        }
    }

    public void cleanup() {
        ALC11.alcCaptureStop((long)this.captureDevice);
        ALC11.alcCaptureCloseDevice((long)this.captureDevice);
        this.buffer.flip();
        byte[] pcm = new byte[this.buffer.limit()];
        this.buffer.get(pcm);
        MemoryUtil.memFree((Buffer)this.buffer);
        this.buffer = null;
        if (this.consumer != null) {
            this.consumer.accept(new Wave(1, 1, 44100, 16, pcm));
        }
    }

    @Override
    public void run() {
        this.init();
        while (this.running) {
            this.pollAndProcess();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.cleanup();
    }
}

