/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips.renderer;

import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.audio.SoundBuffer;
import mchorse.bbs_mod.camera.clips.misc.AudioClip;
import mchorse.bbs_mod.camera.utils.TimeUtils;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.film.clips.renderer.UIClipRenderer;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIAudioClipRenderer
extends UIClipRenderer<AudioClip> {
    @Override
    protected void renderBackground(UIContext context, int color, AudioClip clip, Area area, boolean selected, boolean current) {
        Link link = (Link)clip.audio.get();
        if (link != null) {
            SoundBuffer player = BBSModClient.getSounds().get(link, true);
            if (player != null) {
                int offset = (Integer)clip.offset.get();
                context.batcher.box(area.x, area.y, area.ex(), area.ey(), Colors.mulRGB(color, 0.6f));
                player.getWaveform().render(context.batcher, -1, area.x, area.y, area.w, area.h, TimeUtils.toSeconds(offset), TimeUtils.toSeconds(offset + (Integer)clip.duration.get()));
            }
        } else {
            super.renderBackground(context, color, clip, area, selected, current);
        }
    }
}

