/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.math.MathBuilder;
import mchorse.bbs_mod.settings.values.numeric.ValueDouble;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.settings.values.numeric.ValueInt;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.events.UITrackpadDragEndEvent;
import mchorse.bbs_mod.ui.framework.elements.events.UITrackpadDragStartEvent;
import mchorse.bbs_mod.ui.framework.elements.input.text.UIBaseTextbox;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.Factor;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.Timer;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class UITrackpad
extends UIBaseTextbox {
    private static final Set<Character> allowedNumberCharacters = ".-+/*^%() ".chars().mapToObj(o -> Character.valueOf((char)o)).collect(Collectors.toSet());
    private static final Factor globalFactor = new Factor(20, 1, 40, x -> {
        if (x <= 10) {
            return (double)x.intValue() / 100.0;
        }
        if (x <= 20) {
            return (double)(x - 10) / 10.0;
        }
        if (x <= 30) {
            return (double)(x - 20) / 1.0;
        }
        return (double)(x - 30) * 10.0;
    });
    private static final DecimalFormat FORMAT = new DecimalFormat("#.###");
    public Consumer<Double> callback;
    protected double value;
    public double strong = 1.0;
    public double normal = 0.25;
    public double weak = 0.05;
    public double increment = 1.0;
    public double min = Double.NEGATIVE_INFINITY;
    public double max = Double.POSITIVE_INFINITY;
    public boolean integer;
    public boolean delayedInput;
    public boolean onlyNumbers;
    public boolean relative;
    public boolean allowCanceling = true;
    public IKey forcedLabel;
    private boolean wasInside;
    private boolean dragging;
    private int shiftX;
    private int initialX;
    private int initialY;
    private double lastValue;
    private Timer changed = new Timer(30L);
    private long time;
    private Area plusOne = new Area();
    private Area minusOne = new Area();

    public static String format(double number) {
        return FORMAT.format(number).replace(',', '.');
    }

    public UITrackpad() {
        this(null);
    }

    public UITrackpad(Consumer<Double> callback) {
        this.callback = callback;
        this.setValue(0.0);
        this.h(20);
    }

    public UITrackpad max(double max) {
        this.max = max;
        return this;
    }

    public UITrackpad limit(double min) {
        this.min = min;
        return this;
    }

    public UITrackpad limit(double min, double max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public UITrackpad limit(ValueInt value) {
        return this.limit(((Integer)value.getMin()).intValue(), ((Integer)value.getMax()).intValue(), true);
    }

    public UITrackpad limit(ValueFloat value) {
        return this.limit(((Float)value.getMin()).floatValue(), ((Float)value.getMax()).floatValue(), false);
    }

    public UITrackpad limit(ValueDouble value) {
        return this.limit((Double)value.getMin(), (Double)value.getMax(), false);
    }

    public UITrackpad limit(double min, double max, boolean integer) {
        this.integer = integer;
        return this.limit(min, max);
    }

    public UITrackpad integer() {
        this.integer = true;
        return this;
    }

    public UITrackpad increment(double increment) {
        this.increment = increment;
        return this;
    }

    public UITrackpad values(double normal) {
        this.normal = normal;
        this.weak = normal / 5.0;
        this.strong = normal * 5.0;
        return this;
    }

    public UITrackpad values(double normal, double weak, double strong) {
        this.normal = normal;
        this.weak = weak;
        this.strong = strong;
        return this;
    }

    public UITrackpad delayedInput() {
        this.delayedInput = true;
        return this;
    }

    public UITrackpad onlyNumbers() {
        this.onlyNumbers = true;
        return this;
    }

    public UITrackpad relative(boolean relative) {
        this.relative = relative;
        return this;
    }

    public UITrackpad forcedLabel(IKey label) {
        this.forcedLabel = label;
        return this;
    }

    public UITrackpad disableCanceling() {
        this.allowCanceling = false;
        return this;
    }

    public UITrackpad degrees() {
        return this.increment(15.0).values(1.0, 0.1, 5.0);
    }

    public UITrackpad block() {
        return this.increment(0.0625).values(0.03125, 0.0078125, 0.5);
    }

    public UITrackpad metric() {
        return this.values(0.1, 0.01, 1.0);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isDraggingTime() {
        return this.isDragging() && System.currentTimeMillis() - this.time > 150L;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.setValueInternal(value);
        this.textbox.setText(this.integer ? String.valueOf((int)this.value) : String.valueOf(this.value));
        this.textbox.moveCursorToStart();
    }

    private void setValueInternal(double value) {
        value = MathUtils.clamp(value, this.min, this.max);
        if (this.integer) {
            value = (int)value;
        }
        this.value = value;
    }

    public void setValueAndNotify(double value) {
        double oldValue = this.value;
        this.setValue(value);
        this.accept(value, oldValue);
    }

    private void accept(double value, double oldValue) {
        if (this.callback != null) {
            this.callback.accept(this.relative ? value - oldValue : this.value);
        }
    }

    @Override
    public void unfocus(UIContext context) {
        this.evaluate();
        super.unfocus(context);
        if (this.delayedInput) {
            this.setValueAndNotify(this.value);
        } else {
            this.setValue(this.value);
        }
    }

    @Override
    public void resize() {
        super.resize();
        int w = this.area.w < 60 ? 12 : 20;
        this.textbox.area.copy(this.area);
        this.plusOne.copy(this.area);
        this.minusOne.copy(this.area);
        this.plusOne.w = this.minusOne.w = w;
        this.plusOne.x = this.area.ex() - w;
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (this.allowCanceling && context.mouseButton == 1 && this.isDragging()) {
            this.setValueAndNotify(this.lastValue);
            this.wasInside = false;
            this.dragging = false;
            this.shiftX = 0;
            return true;
        }
        if (context.mouseButton == 2 && this.area.isInside(context)) {
            this.setValueAndNotify(-this.value);
            return true;
        }
        this.wasInside = this.area.isInside(context);
        if (context.mouseButton == 0) {
            if (this.textbox.isFocused()) {
                this.textbox.mouseClicked(context.mouseX, context.mouseY, context.mouseButton);
                if (!this.textbox.isFocused()) {
                    context.focus(null);
                }
            }
            if (this.wasInside && !this.textbox.isFocused()) {
                if (Window.isCtrlPressed()) {
                    this.setValueAndNotify(Math.round(this.value));
                    this.wasInside = false;
                    return true;
                }
                this.dragging = true;
                this.initialX = context.mouseX;
                this.initialY = context.mouseY;
                this.lastValue = this.value;
                this.time = System.currentTimeMillis();
                this.getEvents().emit(new UITrackpadDragStartEvent(this));
            }
        }
        return context.mouseButton == 0 && this.wasInside;
    }

    @Override
    public boolean subMouseReleased(UIContext context) {
        if (context.mouseButton == 1 && this.isDragging()) {
            this.setValueAndNotify(this.lastValue);
            this.wasInside = false;
            this.dragging = false;
            this.shiftX = 0;
            return true;
        }
        this.textbox.mouseReleased(context.mouseX, context.mouseY, context.mouseButton);
        if (context.mouseButton == 0 && !this.isDraggingTime() && !this.textbox.isFocused() && this.wasInside) {
            if (this.plusOne.isInside(context)) {
                this.setValueAndNotify(this.value + this.increment);
            } else if (this.minusOne.isInside(context)) {
                this.setValueAndNotify(this.value - this.increment);
            } else {
                this.textbox.setFocused(true);
                this.textbox.moveCursorToEnd();
                context.focus(this);
            }
        }
        if (this.delayedInput && this.isDraggingTime()) {
            this.setValueAndNotify(this.value);
        }
        if (this.dragging) {
            this.getEvents().emit(new UITrackpadDragEndEvent(this));
        }
        this.wasInside = false;
        this.dragging = false;
        this.shiftX = 0;
        return super.subMouseReleased(context);
    }

    @Override
    protected boolean subMouseScrolled(UIContext context) {
        Area area = new Area();
        int w = this.area.w / 2;
        area.copy(this.area);
        area.x = area.mx() - w / 2;
        area.w = w;
        if (this.dragging) {
            globalFactor.addX((int)context.mouseWheel);
            context.notifyOrUpdate(UIKeys.TRACKPAD_GLOBAL_AMPLIFIER.format(globalFactor.getValue()), 0x3366FF);
            return true;
        }
        if (area.isInside(context) && context.hasNotScrolledForMore(500L) && ((Boolean)BBSSettings.enableTrackpadScrolling.get()).booleanValue()) {
            if (context.mouseWheel > 0.0) {
                this.setValueAndNotify(this.value + this.getValueModifier());
            } else {
                this.setValueAndNotify(this.value - this.getValueModifier());
            }
            return true;
        }
        return super.subMouseScrolled(context);
    }

    @Override
    public boolean subKeyPressed(UIContext context) {
        if (this.isFocused()) {
            if (context.isHeld(265)) {
                this.setValueAndNotify(this.value + this.getValueModifier());
                return true;
            }
            if (context.isHeld(264)) {
                this.setValueAndNotify(this.value - this.getValueModifier());
                return true;
            }
            if (context.isPressed(258)) {
                context.focus(this, Window.isShiftPressed() ? -1 : 1);
                return true;
            }
            if (context.isPressed(256)) {
                context.unfocus();
                return true;
            }
            if (context.isPressed(257)) {
                this.textbox.setFocused(false);
                context.focus(null);
            }
        } else if (this.area.isInside(context) && !context.isFocused() && (context.isPressed(45) || context.isPressed(333))) {
            this.setValueAndNotify(-this.value);
            return true;
        }
        String old = this.textbox.getText();
        boolean result = this.textbox.keyPressed(context);
        String text = this.textbox.getText();
        if (this.textbox.isFocused() && !text.equals(old)) {
            try {
                double oldValue = this.value;
                this.setValueInternal(text.isEmpty() ? 0.0 : Double.parseDouble(text));
                if (!this.delayedInput) {
                    this.accept(this.value, oldValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void evaluate() {
        String text = this.textbox.getText().trim();
        try {
            Float.parseFloat(text);
            return;
        }
        catch (Exception exception) {
            try {
                MathBuilder builder = new MathBuilder();
                this.setValueAndNotify(builder.parse(text).get().doubleValue());
                this.textbox.moveCursorToEnd();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public boolean subTextInput(UIContext context) {
        char inputCharacter = context.getInputCharacter();
        if (this.onlyNumbers && this.isFocused() && !this.numberCharacterAllowed(inputCharacter)) {
            context.unfocus();
            return false;
        }
        String old = this.textbox.getText();
        boolean result = this.textbox.textInput(inputCharacter);
        String text = this.textbox.getText();
        if (this.textbox.isFocused() && !text.equals(old)) {
            try {
                double oldValue = this.value;
                this.setValueInternal(text.isEmpty() ? 0.0 : Double.parseDouble(text));
                if (!this.delayedInput) {
                    this.accept(this.value, oldValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean numberCharacterAllowed(char character) {
        return Character.isDigit(character) || allowedNumberCharacters.contains(Character.valueOf(character));
    }

    @Override
    public void render(UIContext context) {
        boolean minus;
        int x = this.area.x;
        int y = this.area.y;
        int w = this.area.w;
        int h = this.area.h;
        int padding = 0;
        boolean dragging = this.isDraggingTime();
        boolean plus = !dragging && this.plusOne.isInside(context);
        boolean bl = minus = !dragging && this.minusOne.isInside(context);
        if (this.textbox.isFocused()) {
            this.textbox.render(context);
        } else {
            this.area.render(context.batcher, -16777216);
            if (dragging) {
                int color = (Integer)BBSSettings.primaryColor.get();
                int fx = MathUtils.clamp(context.mouseX, this.area.x + padding, this.area.ex() - padding);
                context.batcher.box(Math.min(fx, this.initialX), this.area.y + padding, Math.max(fx, this.initialX), this.area.ey() - padding, 0xFF000000 | color);
            }
            FontRenderer font = context.batcher.getFont();
            String label = this.forcedLabel == null ? FORMAT.format(this.value) : this.forcedLabel.get();
            int lx = this.area.mx(font.getWidth(label));
            int ly = this.area.my() - font.getHeight() / 2;
            context.batcher.text(label, lx, ly, this.textbox.getColor());
            if (((Boolean)BBSSettings.enableTrackpadIncrements.get()).booleanValue() || this.area.isInside(context)) {
                this.plusOne.render(context.batcher, plus ? 0x22FFFFFF : 0xAFFFFFF, padding);
                this.minusOne.render(context.batcher, minus ? 0x22FFFFFF : 0xAFFFFFF, padding);
                context.batcher.icon(Icons.MOVE_LEFT, minus ? -1 : Colors.setA(-1, 0.5f), x + (this.plusOne.w - Icons.MOVE_LEFT.w) / 2, y + (h - 16) / 2);
                context.batcher.icon(Icons.MOVE_RIGHT, plus ? -1 : Colors.setA(-1, 0.5f), x + w - this.minusOne.w + (this.minusOne.w - Icons.MOVE_RIGHT.w) / 2, y + (h - 16) / 2);
            }
        }
        if (dragging) {
            class_310 mc = class_310.method_1551();
            int ww = mc.method_22683().method_4480();
            double factor = Math.ceil((double)ww / (double)context.menu.width);
            int mouseX = context.globalX(context.mouseX);
            if (this.changed.isTime()) {
                int border = 5;
                int borderPadding = 6;
                boolean stop = false;
                if (mouseX <= 5) {
                    Window.moveCursor(ww - (int)(factor * 6.0), (int)mc.field_1729.method_1604());
                    this.shiftX -= context.menu.width - 12;
                    this.changed.mark();
                    stop = true;
                } else if (mouseX >= context.menu.width - 5) {
                    Window.moveCursor((int)(factor * 6.0), (int)mc.field_1729.method_1604());
                    this.shiftX += context.menu.width - 12;
                    this.changed.mark();
                    stop = true;
                }
                if (!stop) {
                    int dx;
                    if (this.isFocused()) {
                        context.unfocus();
                    }
                    if ((dx = this.shiftX + context.mouseX - this.initialX) != 0) {
                        double value = this.getValueModifier();
                        double diff = (double)(Math.abs(dx) - 3) * value;
                        double newValue = this.lastValue + (dx < 0 ? -diff : diff);
                        double d = newValue = diff < 0.0 ? this.lastValue : newValue;
                        if (this.value != newValue) {
                            if (this.delayedInput) {
                                this.setValue(newValue);
                            } else {
                                this.setValueAndNotify(newValue);
                            }
                        }
                    }
                }
            }
            context.batcher.outlineCenter(this.initialX, this.initialY, 4.0f, -1);
        }
        this.renderLockedArea(context);
        super.render(context);
    }

    protected double getValueModifier() {
        double value = this.normal;
        if (Window.isShiftPressed()) {
            value = this.strong;
        } else if (Window.isCtrlPressed()) {
            value = this.increment;
        } else if (Window.isAltPressed()) {
            value = this.weak;
        }
        return value * globalFactor.getValue();
    }

    static {
        FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
        FORMAT.setGroupingUsed(false);
        FORMAT.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
    }
}

