/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.keys;

import java.util.Objects;
import java.util.function.Supplier;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.utils.keys.KeyAction;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Keybind {
    private IKey label;
    private IKey category;
    private KeyCombo combo;
    public Runnable callback;
    public boolean inside;
    public Supplier<Boolean> active;

    public Keybind(KeyCombo combo, Runnable callback) {
        this.combo = combo;
        this.callback = callback;
    }

    public Keybind inside() {
        this.inside = true;
        return this;
    }

    public Keybind active(Supplier<Boolean> active) {
        this.active = active;
        return this;
    }

    public Keybind label(IKey label) {
        this.label = label;
        return this;
    }

    public Keybind category(IKey category) {
        this.category = category;
        return this;
    }

    public int getScore() {
        return this.combo.keys.size();
    }

    public IKey getLabel() {
        return this.label == null ? this.combo.label : this.label;
    }

    public IKey getCategory() {
        return this.category == null ? this.combo.category : this.category;
    }

    public String getKeyCombo() {
        return this.combo.getKeyCombo();
    }

    public boolean check(int keyCode, KeyAction keyAction, boolean inside) {
        if (keyAction == KeyAction.REPEAT && !this.combo.repeatable) {
            return false;
        }
        if (keyCode != this.combo.getMainKey()) {
            return false;
        }
        for (int i = 1; i < this.combo.keys.size(); ++i) {
            if (this.isKeyDown(this.combo.keys.get(i))) continue;
            return false;
        }
        return this.inside ? inside : true;
    }

    public boolean checkMouse(int mouseButton, boolean inside) {
        if ((mouseButton = -mouseButton) != this.combo.getMainKey()) {
            return false;
        }
        for (int i = 1; i < this.combo.keys.size(); ++i) {
            if (this.isKeyDown(this.combo.keys.get(i))) continue;
            return false;
        }
        return this.inside ? inside : true;
    }

    protected boolean isKeyDown(int key) {
        if (key < 0) {
            return Window.isMouseButtonPressed(-key);
        }
        if (key == 340 || key == 344) {
            return Window.isShiftPressed();
        }
        if (key == 341 || key == 345) {
            return Window.isCtrlPressed();
        }
        if (key == 342 || key == 346) {
            return Window.isAltPressed();
        }
        return Window.isKeyPressed(key);
    }

    public boolean isActive() {
        return this.active == null || this.active.get() != false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Keybind) {
            Keybind keybind = (Keybind)obj;
            return Objects.equals(this.combo.keys, keybind.combo.keys) && this.inside == keybind.inside;
        }
        return super.equals(obj);
    }
}

