/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.resizers;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.utils.resizers.BaseResizer;
import mchorse.bbs_mod.ui.utils.resizers.ChildResizer;
import mchorse.bbs_mod.ui.utils.resizers.IResizer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class AutomaticResizer
extends BaseResizer {
    public UIElement parent;
    public int margin;
    public int padding;
    public int height;

    public AutomaticResizer(UIElement parent, int margin) {
        this.parent = parent;
        this.margin = margin;
        this.setup();
    }

    public AutomaticResizer padding(int padding) {
        this.padding = padding;
        return this;
    }

    public AutomaticResizer height(int height) {
        this.height = height;
        return this;
    }

    public void setup() {
        for (IUIElement child : this.parent.getChildren()) {
            if (!(child instanceof UIElement)) continue;
            UIElement element = (UIElement)child;
            element.resizer(this.child(element));
        }
    }

    public IResizer child(UIElement element) {
        ChildResizer child = new ChildResizer(this, element);
        return child;
    }

    public List<ChildResizer> getResizers() {
        ArrayList<ChildResizer> resizers = new ArrayList<ChildResizer>();
        for (IUIElement element : this.parent.getChildren()) {
            UIElement elem;
            if (!(element instanceof UIElement) || !((elem = (UIElement)element).resizer() instanceof ChildResizer)) continue;
            resizers.add((ChildResizer)elem.resizer());
        }
        return resizers;
    }

    @Override
    public void add(UIElement parent, UIElement child) {
        child.resizer(this.child(child));
    }

    @Override
    public void remove(UIElement parent, UIElement child) {
        IResizer resizer = child.resizer();
        if (resizer instanceof ChildResizer) {
            child.resizer(((ChildResizer)resizer).resizer);
        }
    }

    @Override
    public int getX() {
        return 0;
    }

    @Override
    public int getY() {
        return 0;
    }

    @Override
    public int getW() {
        return 0;
    }

    @Override
    public int getH() {
        return 0;
    }
}

