/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.function.Predicate;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.mixin.LevelPropertiesAccessor;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.ServerNetwork;
import mchorse.bbs_mod.settings.Settings;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2246;
import net.minecraft.class_2262;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_5219;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class BBSCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        Predicate<class_2168> hasPermissions = source -> source.method_9259(2);
        LiteralArgumentBuilder bbs = (LiteralArgumentBuilder)class_2170.method_9247((String)"bbs").requires(source -> true);
        BBSCommands.registerMorphCommand((LiteralArgumentBuilder<class_2168>)bbs, environment, hasPermissions);
        BBSCommands.registerMorphEntityCommand((LiteralArgumentBuilder<class_2168>)bbs, environment, hasPermissions);
        BBSCommands.registerFilmsCommand((LiteralArgumentBuilder<class_2168>)bbs, environment, hasPermissions);
        BBSCommands.registerDCCommand((LiteralArgumentBuilder<class_2168>)bbs, environment, hasPermissions);
        BBSCommands.registerOnHeadCommand((LiteralArgumentBuilder<class_2168>)bbs, environment, hasPermissions);
        BBSCommands.registerConfigCommand((LiteralArgumentBuilder<class_2168>)bbs, environment, hasPermissions);
        BBSCommands.registerCheatsCommand((LiteralArgumentBuilder<class_2168>)bbs, environment);
        BBSCommands.registerBoomCommand((LiteralArgumentBuilder<class_2168>)bbs, environment, hasPermissions);
        BBSCommands.registerStructureSaveCommand((LiteralArgumentBuilder<class_2168>)bbs, environment, hasPermissions);
        dispatcher.register(bbs);
    }

    private static void registerStructureSaveCommand(LiteralArgumentBuilder<class_2168> bbs, class_2170.class_5364 environment, Predicate<class_2168> hasPermissions) {
        LiteralArgumentBuilder structures = class_2170.method_9247((String)"structures");
        LiteralArgumentBuilder save = class_2170.method_9247((String)"save");
        RequiredArgumentBuilder name = class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word());
        RequiredArgumentBuilder from = class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698());
        RequiredArgumentBuilder to = class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698());
        bbs.then(structures.then(save.then(name.then(from.then(to.executes(BBSCommands::saveStructure))))));
    }

    private static void registerMorphCommand(LiteralArgumentBuilder<class_2168> bbs, class_2170.class_5364 environment, Predicate<class_2168> hasPermissions) {
        LiteralArgumentBuilder morph = class_2170.method_9247((String)"morph");
        RequiredArgumentBuilder target = class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308());
        RequiredArgumentBuilder form = class_2170.method_9244((String)"form", (ArgumentType)StringArgumentType.greedyString());
        morph.then(((RequiredArgumentBuilder)target.executes(BBSCommands::morphCommandDemorph)).then(form.executes(BBSCommands::morphCommandMorph)));
        bbs.then(morph.requires(hasPermissions));
    }

    private static void registerMorphEntityCommand(LiteralArgumentBuilder<class_2168> bbs, class_2170.class_5364 environment, Predicate<class_2168> hasPermissions) {
        LiteralArgumentBuilder morph = class_2170.method_9247((String)"morph_entity");
        morph.executes(source -> {
            class_3222 player;
            Form form;
            class_1297 entity = ((class_2168)source.getSource()).method_9228();
            if (entity instanceof class_3222 && (form = Morph.getMobForm((class_1657)(player = (class_3222)entity))) != null) {
                ServerNetwork.sendMorphToTracked(player, form);
                Morph.getMorph(entity).setForm(FormUtils.copy(form));
            }
            return 1;
        });
        bbs.then(morph.requires(hasPermissions));
    }

    private static void registerFilmsCommand(LiteralArgumentBuilder<class_2168> bbs, class_2170.class_5364 environment, Predicate<class_2168> hasPermissions) {
        LiteralArgumentBuilder scene = class_2170.method_9247((String)"films");
        LiteralArgumentBuilder play = class_2170.method_9247((String)"play");
        LiteralArgumentBuilder stop = class_2170.method_9247((String)"stop");
        RequiredArgumentBuilder target = class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308());
        RequiredArgumentBuilder playFilm = class_2170.method_9244((String)"film", (ArgumentType)StringArgumentType.string());
        RequiredArgumentBuilder stopFilm = class_2170.method_9244((String)"film", (ArgumentType)StringArgumentType.string());
        RequiredArgumentBuilder camera = class_2170.method_9244((String)"camera", (ArgumentType)BoolArgumentType.bool());
        playFilm.suggests((ctx, builder) -> {
            for (String key : BBSMod.getFilms().getKeys()) {
                builder.suggest(key);
            }
            return builder.buildFuture();
        });
        stopFilm.suggests((ctx, builder) -> {
            for (String key : BBSMod.getFilms().getKeys()) {
                builder.suggest(key);
            }
            return builder.buildFuture();
        });
        scene.then(((RequiredArgumentBuilder)target.then(play.then(((RequiredArgumentBuilder)playFilm.executes(source -> BBSCommands.sceneCommandPlay((CommandContext<class_2168>)source, true))).then(camera.executes(source -> BBSCommands.sceneCommandPlay((CommandContext<class_2168>)source, BoolArgumentType.getBool((CommandContext)source, (String)"camera"))))))).then(stop.then(stopFilm.executes(BBSCommands::sceneCommandStop))));
        bbs.then(scene.requires(hasPermissions));
    }

    private static void registerDCCommand(LiteralArgumentBuilder<class_2168> bbs, class_2170.class_5364 environment, Predicate<class_2168> hasPermissions) {
        LiteralArgumentBuilder dc = class_2170.method_9247((String)"dc");
        LiteralArgumentBuilder shutdown = class_2170.method_9247((String)"shutdown");
        LiteralArgumentBuilder start = class_2170.method_9247((String)"start");
        LiteralArgumentBuilder stop = class_2170.method_9247((String)"stop");
        bbs.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)dc.requires(hasPermissions)).then(start.executes(BBSCommands::DCCommandStart))).then(stop.executes(BBSCommands::DCCommandStop))).then(shutdown.executes(BBSCommands::DCCommandShutdown)));
    }

    private static void registerOnHeadCommand(LiteralArgumentBuilder<class_2168> bbs, class_2170.class_5364 environment, Predicate<class_2168> hasPermissions) {
        LiteralArgumentBuilder onHead = class_2170.method_9247((String)"on_head");
        bbs.then(((LiteralArgumentBuilder)onHead.requires(hasPermissions)).executes(BBSCommands::onHead));
    }

    private static void registerConfigCommand(LiteralArgumentBuilder<class_2168> bbs, class_2170.class_5364 environment, Predicate<class_2168> hasPermissions) {
        LiteralArgumentBuilder config = class_2170.method_9247((String)"config");
        ((LiteralArgumentBuilder)config.requires(ctx -> ctx.method_9259(4))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"option", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Settings settings = BBSMod.getSettings().modules.get("bbs");
            if (settings != null) {
                for (ValueGroup value : settings.categories.values()) {
                    for (BaseValue baseValue : value.getAll()) {
                        builder.suggest(value.getId() + "." + baseValue.getId());
                    }
                }
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            Settings settings = BBSMod.getSettings().modules.get("bbs");
            if (settings != null) {
                BaseValue baseValue;
                String option = StringArgumentType.getString((CommandContext)ctx, (String)"option");
                String value = StringArgumentType.getString((CommandContext)ctx, (String)"value");
                BaseType valueType = DataToString.fromString(value);
                String[] split = option.split("\\.");
                if (valueType != null && split.length >= 2 && (baseValue = settings.get(split[0], split[1])) != null) {
                    baseValue.fromData(valueType);
                    settings.saveLater();
                }
            }
            return 1;
        }))));
        bbs.then(config.requires(hasPermissions));
    }

    private static void registerCheatsCommand(LiteralArgumentBuilder<class_2168> bbs, class_2170.class_5364 environment) {
        if (environment.field_25423) {
            return;
        }
        bbs.then(class_2170.method_9247((String)"cheats").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
            boolean enabled = BoolArgumentType.getBool((CommandContext)ctx, (String)"enabled");
            class_5219 saveProperties = server.method_27728();
            if (saveProperties instanceof LevelPropertiesAccessor) {
                LevelPropertiesAccessor accessor = (LevelPropertiesAccessor)saveProperties;
                class_1940 levelInfo = saveProperties.method_27433();
                accessor.bbs$setLevelInfo(new class_1940(levelInfo.method_27339(), levelInfo.method_8574(), levelInfo.method_8583(), levelInfo.method_27340(), enabled, levelInfo.method_27341(), levelInfo.method_29558()));
                for (class_3222 serverPlayerEntity : server.method_3760().method_14571()) {
                    server.method_3734().method_9241(serverPlayerEntity);
                    ServerNetwork.sendCheatsPermission(serverPlayerEntity, enabled);
                }
            }
            return 1;
        })));
    }

    private static void registerBoomCommand(LiteralArgumentBuilder<class_2168> bbs, class_2170.class_5364 environment, Predicate<class_2168> hasPermissions) {
        bbs.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"boom").requires(hasPermissions)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"radius", (ArgumentType)FloatArgumentType.floatArg((float)1.0f)).then(class_2170.method_9244((String)"fire", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_243 pos = class_2277.method_9736((CommandContext)ctx, (String)"pos");
            float radius = FloatArgumentType.getFloat((CommandContext)ctx, (String)"radius");
            boolean fire = BoolArgumentType.getBool((CommandContext)ctx, (String)"fire");
            source.method_9225().method_8537(null, pos.field_1352, pos.field_1351, pos.field_1350, radius, fire, class_1937.class_7867.field_40889);
            return 1;
        })))));
    }

    private static int morphCommandDemorph(CommandContext<class_2168> source) throws CommandSyntaxException {
        class_3222 entity = class_2186.method_9315(source, (String)"target");
        ServerNetwork.sendMorphToTracked(entity, null);
        Morph.getMorph((class_1297)entity).setForm(null);
        return 1;
    }

    private static int morphCommandMorph(CommandContext<class_2168> source) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(source, (String)"target");
        String formData = StringArgumentType.getString(source, (String)"form");
        try {
            Form form = FormUtils.fromData(DataToString.mapFromString(formData));
            for (class_3222 player : players) {
                ServerNetwork.sendMorphToTracked(player, form);
                Morph.getMorph((class_1297)player).setForm(FormUtils.copy(form));
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static int sceneCommandPlay(CommandContext<class_2168> source, boolean withCamera) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(source, (String)"target");
        String filmId = StringArgumentType.getString(source, (String)"film");
        for (class_3222 player : players) {
            ServerNetwork.sendPlayFilm(player, filmId, withCamera);
        }
        return 1;
    }

    private static int sceneCommandStop(CommandContext<class_2168> source) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(source, (String)"target");
        String filmId = StringArgumentType.getString(source, (String)"film");
        for (class_3222 player : players) {
            ServerNetwork.sendStopFilm(player, filmId);
        }
        return 1;
    }

    private static int DCCommandShutdown(CommandContext<class_2168> source) {
        BBSMod.getActions().resetDamage(((class_2168)source.getSource()).method_9225());
        return 1;
    }

    private static int DCCommandStart(CommandContext<class_2168> source) {
        BBSMod.getActions().trackDamage(((class_2168)source.getSource()).method_9225());
        return 1;
    }

    private static int DCCommandStop(CommandContext<class_2168> source) {
        BBSMod.getActions().stopDamage(((class_2168)source.getSource()).method_9225());
        return 1;
    }

    private static int onHead(CommandContext<class_2168> source) {
        class_1309 livingEntity;
        class_1799 stack;
        class_1297 class_12972 = ((class_2168)source.getSource()).method_9228();
        if (class_12972 instanceof class_1309 && !(stack = (livingEntity = (class_1309)class_12972).method_6118(class_1304.field_6173)).method_7960()) {
            livingEntity.method_5673(class_1304.field_6169, stack.method_7972());
        }
        return 1;
    }

    private static int saveStructure(CommandContext<class_2168> source) {
        class_3499 structureTemplate;
        String name = StringArgumentType.getString(source, (String)"name");
        class_2338 from = class_2262.method_48299(source, (String)"from");
        class_2338 to = class_2262.method_48299(source, (String)"to");
        class_3218 world = ((class_2168)source.getSource()).method_9225();
        class_3485 structureTemplateManager = world.method_14183();
        try {
            structureTemplate = structureTemplateManager.method_15091(new class_2960(name));
        }
        catch (class_151 e) {
            return 0;
        }
        class_2338 min = new class_2338(Math.min(from.method_10263(), to.method_10263()), Math.min(from.method_10264(), to.method_10264()), Math.min(from.method_10260(), to.method_10260()));
        class_2338 max = new class_2338(Math.max(from.method_10263(), to.method_10263()), Math.max(from.method_10264(), to.method_10264()), Math.max(from.method_10260(), to.method_10260()));
        class_2338 size = max.method_10059((class_2382)min).method_10069(1, 1, 1);
        structureTemplate.method_15174((class_1937)world, min, (class_2382)size, true, class_2246.field_10369);
        try {
            if (structureTemplateManager.method_15093(new class_2960(name))) {
                return 1;
            }
        }
        catch (class_151 class_1512) {
            // empty catch block
        }
        return 0;
    }
}

