/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mchorse.bbs_mod.actions.ActionPlayer;
import mchorse.bbs_mod.actions.ActionRecorder;
import mchorse.bbs_mod.actions.DamageControl;
import mchorse.bbs_mod.actions.PlayerType;
import mchorse.bbs_mod.actions.types.ActionClip;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.utils.DataPath;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ActionManager {
    private List<ActionPlayer> players = new ArrayList<ActionPlayer>();
    private Map<class_3222, ActionRecorder> recorders = new HashMap<class_3222, ActionRecorder>();
    private Map<class_3218, DamageControl> dc = new HashMap<class_3218, DamageControl>();

    public void reset() {
        this.players.clear();
        this.recorders.clear();
        this.dc.clear();
    }

    public void tick() {
        this.players.removeIf(player -> {
            boolean tick = player.tick();
            if (tick) {
                if (player.stopDamage) {
                    this.stopDamage(player.getWorld());
                }
                player.stop();
            }
            return tick;
        });
        for (Map.Entry<class_3222, ActionRecorder> entry : this.recorders.entrySet()) {
            entry.getValue().tick(entry.getKey());
        }
    }

    public void syncData(String filmId, DataPath key, BaseType data) {
        for (ActionPlayer player : this.players) {
            if (!player.film.getId().equals(filmId)) continue;
            player.syncData(key, data);
        }
    }

    public ActionPlayer getPlayer(String filmId) {
        for (ActionPlayer player : this.players) {
            if (!player.film.getId().equals(filmId)) continue;
            return player;
        }
        return null;
    }

    public ActionPlayer play(class_3222 serverPlayer, class_3218 world, Film film, int tick) {
        return this.play(serverPlayer, world, film, tick, 0, -1, PlayerType.NORMAL);
    }

    public ActionPlayer play(class_3222 serverPlayer, class_3218 world, Film film, int tick, PlayerType type) {
        return this.play(serverPlayer, world, film, tick, 0, -1, type);
    }

    public ActionPlayer play(class_3222 serverPlayer, class_3218 world, Film film, int tick, int countdown, int exception, PlayerType type) {
        if (film != null) {
            ActionPlayer player = new ActionPlayer(serverPlayer, world, film, tick, countdown, exception, type);
            this.players.add(player);
            this.trackDamage(world);
            return player;
        }
        return null;
    }

    public void stop(String filmId) {
        Iterator<ActionPlayer> it = this.players.iterator();
        while (it.hasNext()) {
            ActionPlayer next = it.next();
            if (!next.film.getId().equals(filmId)) continue;
            this.stopDamage(next.getWorld());
            next.stop();
            it.remove();
        }
    }

    public void startRecording(Film film, class_3222 entity, int tick, int countdown, int replayId) {
        ActionPlayer play = this.play(entity, entity.method_51469(), film, tick, countdown, replayId, PlayerType.RECORDING);
        play.stopDamage = false;
        this.recorders.put(entity, new ActionRecorder(film, entity, tick, countdown));
    }

    public void addAction(class_3222 entity, Supplier<ActionClip> supplier) {
        ActionClip actionClip;
        ActionRecorder recorder = this.recorders.get(entity);
        if (recorder != null && supplier != null && (actionClip = supplier.get()) != null) {
            recorder.add(actionClip);
        }
    }

    public ActionRecorder stopRecording(class_3222 entity) {
        ActionRecorder remove = this.recorders.remove(entity);
        this.stop(remove.getFilm().getId());
        this.stopDamage(entity.method_51469());
        return remove;
    }

    public void trackDamage(class_3218 world) {
        DamageControl damageControl = this.dc.get(world);
        if (damageControl == null) {
            this.dc.put(world, new DamageControl(world));
        } else {
            ++damageControl.nested;
        }
    }

    public void stopDamage(class_3218 world) {
        DamageControl damageControl = this.dc.get(world);
        if (damageControl != null) {
            if (damageControl.nested > 0) {
                --damageControl.nested;
            } else {
                damageControl.restore();
                this.dc.remove(world);
            }
        }
    }

    public void resetDamage(class_3218 world) {
        DamageControl dc = this.dc.remove(world);
        if (dc != null) {
            dc.restore();
        }
    }

    public void changedBlock(class_2338 pos, class_2680 state, class_2586 blockEntity) {
        for (DamageControl control : this.dc.values()) {
            control.addBlock(pos, state, blockEntity);
        }
    }

    public void spawnedEntity(class_1297 entity) {
        for (DamageControl control : this.dc.values()) {
            control.addEntity(entity);
        }
    }
}

