/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.audio;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.audio.AudioReader;
import mchorse.bbs_mod.audio.SoundBuffer;
import mchorse.bbs_mod.audio.Wave;
import mchorse.bbs_mod.audio.Waveform;
import mchorse.bbs_mod.audio.wav.WaveWriter;
import mchorse.bbs_mod.camera.clips.misc.AudioClip;
import mchorse.bbs_mod.camera.utils.TimeUtils;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class AudioRenderer {
    public static void renderAll(Batcher2D batcher, List<AudioClip> clips, float tick, int x, int y, int w, int h, int sw, int sh) {
        if (!((Boolean)BBSSettings.audioWaveformVisible.get()).booleanValue()) {
            return;
        }
        for (AudioClip clip : clips) {
            SoundBuffer audio = BBSModClient.getSounds().get((Link)clip.audio.get(), true);
            if (audio == null || audio.getWaveform() == null || !clip.isInside((int)tick)) continue;
            AudioRenderer.renderWaveform(batcher, audio, clip, tick, x, y, w, h, sw, sh);
            y += h + 8;
        }
    }

    public static void renderWaveform(Batcher2D batcher, SoundBuffer audio, AudioClip clip, float tick, int x, int y, int w, int h, int sw, int sh) {
        float brightness = 0.45f;
        int half = w / 2;
        batcher.gradientVBox(x + 2, y + 2, x + w - 2, y + h, 0, -2013265920);
        batcher.box(x + 1, y, x + 2, y + h, -1426063361);
        batcher.box(x + w - 2, y, x + w - 1, y + h, -1426063361);
        batcher.box(x, y + h - 1, x + w, y + h, -1);
        batcher.clip(x + 2, y + 2, w - 4, h - 4, sw, sh);
        Waveform wave = audio.getWaveform();
        float duration = (float)w / (float)wave.getPixelsPerSecond();
        float playback = TimeUtils.toSeconds(tick - (float)((Integer)clip.tick.get()).intValue() + (float)((Integer)clip.offset.get()).intValue());
        int offset = (int)(playback * (float)wave.getPixelsPerSecond());
        int waveW = wave.getWidth();
        int runningOffset = waveW - offset;
        if (runningOffset > 0) {
            wave.render(batcher, -1, x + half, y, half, h, playback, playback + duration / 2.0f);
        }
        if (offset > 0) {
            int color = Colors.COLOR.set(0.45f, 0.45f, 0.45f, 1.0f).getARGBColor();
            wave.render(batcher, color, x, y, half, h, playback - duration / 2.0f, playback);
        }
        batcher.unclip(sw, sh);
        batcher.box(x + half, y + 1, x + half + 1, y + h - 1, -11012822);
        FontRenderer fontRenderer = batcher.getFont();
        if (((Boolean)BBSSettings.audioWaveformFilename.get()).booleanValue()) {
            batcher.textCard(audio.getId().toString(), x + 8, y + h / 2 - 4, 0xFFFFFF, -1728053248);
        }
        if (((Boolean)BBSSettings.audioWaveformTime.get()).booleanValue()) {
            int milliseconds = (int)(tick % 20.0f == 0.0f ? 0.0 : (double)(tick % 20.0f) * 5.0);
            String tickLabel = tick + "t (" + (int)playback + "." + StringUtils.leftPad(String.valueOf(milliseconds), 2, "0") + "s)";
            batcher.textCard(tickLabel, x + w - 8 - fontRenderer.getWidth(tickLabel), y + h / 2 - 4, 0xFFFFFF, -1728053248);
        }
    }

    public static boolean renderAudio(File file, List<AudioClip> clips, int totalDuration, int sampleRate) {
        float total = (float)totalDuration / 20.0f;
        HashMap<AudioClip, Wave> map = new HashMap<AudioClip, Wave>();
        for (AudioClip clip : clips) {
            if (!((Boolean)clip.enabled.get()).booleanValue()) continue;
            try {
                map.put(clip, AudioReader.read(BBSMod.getProvider(), (Link)clip.audio.get()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (map.isEmpty()) {
            return false;
        }
        int byteRate = sampleRate * 2;
        int totalBytes = (int)(total * (float)byteRate);
        byte[] bytes = new byte[totalBytes + totalBytes % 2];
        Wave finalWave = new Wave(1, 1, sampleRate, 16, bytes);
        ByteBuffer buffer = MemoryUtil.memAlloc((int)2);
        for (AudioClip clip : clips) {
            try {
                finalWave.add(buffer, (Wave)map.get(clip), TimeUtils.toSeconds(((Integer)clip.tick.get()).intValue()), TimeUtils.toSeconds(((Integer)clip.offset.get()).intValue()), TimeUtils.toSeconds(((Integer)clip.duration.get()).intValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MemoryUtil.memFree((Buffer)buffer);
        try {
            WaveWriter.write(file, finalWave);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

