/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.bobj;

import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Interpolations;

public class BOBJKeyframe {
    public float frame;
    public float value;
    public Interpolation interpolation = Interpolation.LINEAR;
    public float leftX;
    public float leftY;
    public float rightX;
    public float rightY;

    public static BOBJKeyframe parse(String[] tokens) {
        if (tokens.length == 8) {
            float leftX = Float.parseFloat(tokens[4]);
            float leftY = Float.parseFloat(tokens[5]);
            float rightX = Float.parseFloat(tokens[6]);
            float rightY = Float.parseFloat(tokens[7]);
            return new BOBJKeyframe(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), tokens[3], leftX, leftY, rightX, rightY);
        }
        if (tokens.length == 4) {
            return new BOBJKeyframe(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), tokens[3]);
        }
        if (tokens.length == 3) {
            return new BOBJKeyframe(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
        }
        return null;
    }

    public static Interpolation interpolationFromString(String interp) {
        if (interp.equals("CONSTANT")) {
            return Interpolation.CONSTANT;
        }
        if (interp.equals("BEZIER")) {
            return Interpolation.BEZIER;
        }
        return Interpolation.LINEAR;
    }

    public BOBJKeyframe(float frame, float value) {
        this.frame = frame;
        this.value = value;
    }

    public BOBJKeyframe(float frame, float value, String interp) {
        this(frame, value);
        this.interpolation = BOBJKeyframe.interpolationFromString(interp);
    }

    public BOBJKeyframe(float frame, float value, String interp, float leftX, float leftY, float rightX, float rightY) {
        this(frame, value, interp);
        this.leftX = leftX;
        this.leftY = leftY;
        this.rightX = rightX;
        this.rightY = rightY;
    }

    public static enum Interpolation {
        CONSTANT(Interpolations.CONST),
        LINEAR(Interpolations.LINEAR),
        BEZIER(Interpolations.BEZIER);

        public final IInterp interp;

        private Interpolation(IInterp interp) {
            this.interp = interp;
        }
    }
}

