/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.misc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.audio.SoundPlayer;
import mchorse.bbs_mod.camera.clips.misc.AudioClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.camera.utils.TimeUtils;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AudioClientClip
extends AudioClip {
    public static Map<Link, Float> getPlayback(ClipContext context) {
        return (Map)context.clipData.computeIfAbsent("audio", v -> new ConcurrentHashMap());
    }

    public static void manageSounds(ClipContext context) {
        Map<Link, Float> playback = AudioClientClip.getPlayback(context);
        for (Map.Entry<Link, Float> entry : playback.entrySet()) {
            float tickTime = entry.getValue().floatValue();
            SoundPlayer player = BBSModClient.getSounds().playUnique(entry.getKey());
            if (player == null) continue;
            if (tickTime < 0.0f || tickTime >= player.getBuffer().getDuration()) {
                if (!player.isPlaying()) continue;
                player.pause();
                continue;
            }
            float time = player.getPlaybackPosition();
            float diff = Math.abs(tickTime - time);
            if (context.playing && !player.isPlaying()) {
                player.play();
            } else if (!context.playing && player.isPlaying()) {
                player.pause();
            }
            if (!(diff > 0.05f)) continue;
            player.setPlaybackPosition(tickTime);
        }
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public void shutdown(ClipContext context) {
        Link link = (Link)this.audio.get();
        if (link != null) {
            BBSModClient.getSounds().stop(link);
        }
    }

    @Override
    protected void applyClip(ClipContext context, Position position) {
        Link link = (Link)this.audio.get();
        if (link != null) {
            SoundPlayer player = BBSModClient.getSounds().playUnique(link);
            if (player == null) {
                return;
            }
            float tickTime = ((float)context.relativeTick + context.transition) / 20.0f;
            Map<Link, Float> playback = AudioClientClip.getPlayback(context);
            if (context.relativeTick >= (Integer)this.duration.get() || tickTime < 0.0f) {
                playback.putIfAbsent(link, Float.valueOf(-1.0f));
            } else {
                playback.put(link, Float.valueOf(TimeUtils.toSeconds(((Integer)this.offset.get()).intValue()) + tickTime));
            }
        }
    }

    @Override
    protected Clip create() {
        return new AudioClientClip();
    }
}

