/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.misc;

import java.util.HashMap;
import java.util.List;
import mchorse.bbs_mod.camera.clips.modifiers.TrackerClip;
import mchorse.bbs_mod.camera.data.Angle;
import mchorse.bbs_mod.camera.data.Point;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.film.BaseFilmController;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.utils.MatrixUtils;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class TrackerClientClip
extends TrackerClip {
    @Override
    protected void applyClip(ClipContext context, Position position) {
        IEntity entity;
        Form form;
        List<IEntity> entities = this.getEntities(context);
        if (entities.isEmpty()) {
            return;
        }
        if (!context.applyUnderneath((Integer)this.tick.get(), 0.0f, this.position)) {
            this.position.copy(position);
        }
        Form form2 = form = (entity = entities.get(0)) == null ? null : entity.getForm();
        if (form == null) {
            return;
        }
        class_4587 tempStack = new class_4587();
        HashMap<String, Matrix4f> map = new HashMap<String, Matrix4f>();
        Vector3f relativeFormPos = new Vector3f();
        String targetGroup = (String)this.group.get();
        FormUtilsClient.getRenderer(form).collectMatrices(entity, null, tempStack, map, "", context.transition);
        if (!map.containsKey(targetGroup)) {
            return;
        }
        Matrix4f formTransform = BaseFilmController.getMatrixForRenderWithRotation(entity, position.point.x, position.point.y, position.point.z, context.transition);
        formTransform.mul((Matrix4fc)map.get(targetGroup));
        formTransform.getTranslation(relativeFormPos);
        Matrix3d trackerRot = new Matrix3d((Matrix4fc)formTransform);
        Vector3d relativeTrackerPos = new Vector3d(((Point)this.offset.get()).x, ((Point)this.offset.get()).y, ((Point)this.offset.get()).z);
        trackerRot.transform(relativeTrackerPos);
        relativeTrackerPos.add((Vector3fc)relativeFormPos);
        Vector3d firstCamPos = new Vector3d(this.position.point.x, this.position.point.y, this.position.point.z);
        Vector3d currentCamPos = new Vector3d(position.point.x, position.point.y, position.point.z);
        Vector3d newAngle = new Vector3d();
        Vector3d newPosition = new Vector3d();
        if (((Boolean)this.lookAt.get()).booleanValue()) {
            Angle lookAtAngle = Angle.angle(relativeTrackerPos.x, relativeTrackerPos.y, relativeTrackerPos.z);
            newAngle.set((double)lookAtAngle.pitch, (double)lookAtAngle.yaw, (double)lookAtAngle.roll).add(((Point)this.angle.get()).x, ((Point)this.angle.get()).y, ((Point)this.angle.get()).z);
        } else {
            relativeTrackerPos.add((Vector3dc)currentCamPos);
            if (((Boolean)this.relative.get()).booleanValue()) {
                Vector3d camPosDelta = new Vector3d((Vector3dc)currentCamPos).sub((Vector3dc)firstCamPos);
                trackerRot.transform(camPosDelta);
                relativeTrackerPos.add((Vector3dc)camPosDelta);
            }
            Vector3d offsetAngle = new Vector3d(((Point)this.angle.get()).x, ((Point)this.angle.get()).y, ((Point)this.angle.get()).z);
            offsetAngle.set(Math.toRadians(offsetAngle.x), Math.toRadians(offsetAngle.y), Math.toRadians(offsetAngle.z));
            trackerRot.mul((Matrix3dc)MatrixUtils.RotationOrder.YXZ.getRotationMatrix(offsetAngle.y, offsetAngle.x, offsetAngle.z));
            if (((Boolean)this.relative.get()).booleanValue()) {
                double angleDeltaX = Math.toRadians(position.angle.pitch - this.position.angle.pitch);
                double angleDeltaY = Math.toRadians(position.angle.yaw - this.position.angle.yaw);
                double angleDeltaZ = Math.toRadians(position.angle.roll - this.position.angle.roll);
                trackerRot.mul((Matrix3dc)MatrixUtils.RotationOrder.YXZ.getRotationMatrix(angleDeltaY, angleDeltaX, angleDeltaZ));
            }
            Vector3f globalEulerAngles = MatrixUtils.cast3dTo3f(MatrixUtils.RotationOrder.YXZ.getEulerAngles(trackerRot));
            newAngle.set(Math.toDegrees(globalEulerAngles.x), Math.toDegrees(-globalEulerAngles.y) - 180.0, Math.toDegrees(globalEulerAngles.z));
            newPosition.set((Vector3dc)relativeTrackerPos);
        }
        if (!((Boolean)this.lookAt.get()).booleanValue()) {
            position.point.x = this.isActive(0) ? newPosition.x : position.point.x;
            position.point.y = this.isActive(1) ? newPosition.y : position.point.y;
            position.point.z = this.isActive(2) ? newPosition.z : position.point.z;
        }
        position.angle.yaw = this.isActive(3) ? (float)newAngle.y : position.angle.yaw;
        position.angle.pitch = this.isActive(4) ? (float)newAngle.x : position.angle.pitch;
        position.angle.roll = this.isActive(5) ? (float)newAngle.z : position.angle.roll;
        position.angle.fov = this.isActive(6) ? ((Float)this.fov.get()).floatValue() : position.angle.fov;
    }

    public boolean isActive(int bit) {
        return ((Integer)this.active.get() >> bit & 1) == 1;
    }

    @Override
    protected Clip create() {
        return new TrackerClientClip();
    }
}

