/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.modifiers;

import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.camera.clips.CameraClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipContext;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;

public class RemapperClip
extends CameraClip {
    public final KeyframeChannel<Double> channel = new KeyframeChannel<Double>("channel", KeyframeFactories.DOUBLE);

    public RemapperClip() {
        this.add(this.channel);
        this.channel.insert(0.0f, 0.0);
        this.channel.insert(BBSSettings.getDefaultDuration(), 1.0);
    }

    @Override
    public void applyClip(ClipContext context, Position position) {
        double factor = this.channel.interpolate((float)context.relativeTick + context.transition);
        int duration = (Integer)this.duration.get();
        factor *= (double)duration;
        factor = MathUtils.clamp(factor, 0.0, (double)((float)duration - 1.0E-4f));
        context.applyUnderneath((Integer)this.tick.get() + (int)factor, (float)(factor % 1.0), position);
    }

    @Override
    public Clip create() {
        return new RemapperClip();
    }

    @Override
    protected void breakDownClip(Clip original, int offset) {
        super.breakDownClip(original, offset);
        this.channel.moveX(-offset);
    }
}

