/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.modifiers;

import mchorse.bbs_mod.camera.clips.modifiers.ComponentClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipContext;

public class ShakeClip
extends ComponentClip {
    public final ValueFloat shake = new ValueFloat("shake", Float.valueOf(0.0f));
    public final ValueFloat shakeAmount = new ValueFloat("shakeAmount", Float.valueOf(0.0f));

    public ShakeClip() {
        this.add(this.shake);
        this.add(this.shakeAmount);
        this.active.set(24);
    }

    @Override
    public void applyClip(ClipContext context, Position position) {
        float shake = ((Float)this.shake.get()).floatValue();
        float amount = ((Float)this.shakeAmount.get()).floatValue();
        float x = ((float)context.ticks + context.transition) / (shake == 0.0f ? 1.0f : shake);
        boolean isX = this.isActive(0);
        boolean isY = this.isActive(1);
        boolean isZ = this.isActive(2);
        boolean isYaw = this.isActive(3);
        boolean isPitch = this.isActive(4);
        boolean isRoll = this.isActive(5);
        boolean isFov = this.isActive(6);
        double sin = Math.sin(x);
        double cos = Math.cos(x);
        if (!(!isYaw || !isPitch || isX || isY || isZ || isRoll || isFov)) {
            float swingX = (float)(sin * sin * cos * Math.cos(x / 2.0f));
            float swingY = (float)(cos * sin * sin);
            position.angle.yaw += swingX * amount;
            position.angle.pitch += swingY * amount;
        } else {
            if (isX) {
                position.point.x += sin * (double)amount;
            }
            if (isY) {
                position.point.y -= sin * (double)amount;
            }
            if (isZ) {
                position.point.z += cos * (double)amount;
            }
            if (isYaw) {
                position.angle.yaw = (float)((double)position.angle.yaw + sin * (double)amount);
            }
            if (isPitch) {
                position.angle.pitch = (float)((double)position.angle.pitch + cos * (double)amount);
            }
            if (isRoll) {
                position.angle.roll = (float)((double)position.angle.roll + sin * (double)amount);
            }
            if (isFov) {
                position.angle.fov = (float)((double)position.angle.fov + cos * (double)amount);
            }
        }
    }

    @Override
    public Clip create() {
        return new ShakeClip();
    }
}

