/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.overwrite;

import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.clips.CameraClipContext;
import mchorse.bbs_mod.camera.clips.overwrite.IdleClip;
import mchorse.bbs_mod.camera.data.Point;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipContext;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Interpolation;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.joml.Matrices;
import org.joml.Vector3f;

public class DollyClip
extends IdleClip {
    public final ValueFloat distance = new ValueFloat("distance", Float.valueOf(0.1f));
    public final Interpolation interp = new Interpolation("interp", Interpolations.MAP);
    public final ValueFloat yaw = new ValueFloat("yaw", Float.valueOf(0.0f));
    public final ValueFloat pitch = new ValueFloat("pitch", Float.valueOf(0.0f));

    public DollyClip() {
        this.add(this.distance);
        this.add(this.interp);
        this.add(this.yaw);
        this.add(this.pitch);
    }

    @Override
    public void fromCamera(Camera camera) {
        super.fromCamera(camera);
        this.yaw.set(Float.valueOf(this.position.get().angle.yaw));
        this.pitch.set(Float.valueOf(this.position.get().angle.pitch));
    }

    @Override
    public void applyClip(ClipContext context, Position position) {
        super.applyClip(context, position);
        Point point = this.position.get().point;
        double x = point.x;
        double y = point.y;
        double z = point.z;
        float yaw = ((Float)this.yaw.get()).floatValue();
        float pitch = ((Float)this.pitch.get()).floatValue();
        Vector3f look = Matrices.rotation(MathUtils.toRad(pitch), MathUtils.toRad(180.0f - yaw)).normalize().mul(((Float)this.distance.get()).floatValue());
        float transition = ((float)context.relativeTick + context.transition) / (float)((Integer)this.duration.get()).intValue();
        x = this.interp.interpolate(IInterp.context.set(x, x + (double)look.x, transition));
        y = this.interp.interpolate(IInterp.context.set(y, y + (double)look.y, transition));
        z = this.interp.interpolate(IInterp.context.set(z, z + (double)look.z, transition));
        position.point.set(x, y, z);
    }

    @Override
    public Clip create() {
        return new DollyClip();
    }

    @Override
    protected void breakDownClip(Clip original, int offset) {
        super.breakDownClip(original, offset);
        DollyClip dolly = (DollyClip)original;
        Position position = new Position();
        dolly.apply(new CameraClipContext().setup(offset, 0.0f), position);
        Point point = dolly.position.get().point;
        double dx = point.x - position.point.x;
        double dy = point.y - position.point.y;
        double dz = point.z - position.point.z;
        float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.position.set(position);
        this.distance.set(Float.valueOf(((Float)dolly.distance.get()).floatValue() - distance));
        dolly.distance.set(Float.valueOf(distance));
    }
}

