/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.controller;

import java.util.function.Consumer;
import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.controller.CameraWorkCameraController;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class RunnerCameraController
extends CameraWorkCameraController {
    public int ticks;
    private Position manual;
    private UIFilmPanel panel;
    private Consumer<Boolean> callback;

    public RunnerCameraController(UIFilmPanel panel, Consumer<Boolean> callback) {
        this.panel = panel;
        this.callback = callback;
        this.context.playing = false;
    }

    public boolean isRunning() {
        return this.context.playing;
    }

    public void setPlaying(boolean playing) {
        this.context.playing = playing;
        if (this.callback != null) {
            this.callback.accept(this.context.playing);
        }
    }

    public void toggle(int ticks) {
        this.setPlaying(!this.context.playing);
        this.ticks = ticks;
    }

    public void setManual(Position manual) {
        this.manual = manual;
        if (manual != null && this.panel.getController().getPovMode() != 1) {
            manual.copy(this.position);
        }
    }

    @Override
    public void update() {
        if (this.context.playing && this.manual == null) {
            ++this.ticks;
            if (this.ticks >= this.context.clips.calculateDuration()) {
                this.setPlaying(false);
            }
        }
    }

    @Override
    public void setup(Camera camera, float transition) {
        if (this.manual != null) {
            this.manual.apply(camera);
        } else if (this.context.clips != null) {
            boolean free = this.panel.getController().getPovMode() == 1;
            this.apply(free ? null : camera, this.ticks, this.context.playing ? transition : 0.0f);
        }
        this.panel.getController().handleCamera(camera, transition);
    }
}

