/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.data;

import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.data.Angle;
import mchorse.bbs_mod.camera.data.Point;
import mchorse.bbs_mod.data.IMapSerializable;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.interps.Lerps;

public class Position
implements IMapSerializable {
    public static final Position ZERO = new Position();
    public final Point point = new Point(0.0, 0.0, 0.0);
    public final Angle angle = new Angle(0.0f, 0.0f);

    public Position() {
    }

    public Position(Point point, Angle angle) {
        this.point.set(point);
        this.angle.set(angle);
    }

    public Position(float x, float y, float z, float yaw, float pitch) {
        this.point.set(x, y, z);
        this.angle.set(yaw, pitch);
    }

    public Position(float x, float y, float z, float yaw, float pitch, float roll, float fov) {
        this.point.set(x, y, z);
        this.angle.set(yaw, pitch, roll, fov);
    }

    public Position(Camera camera) {
        this.set(camera);
    }

    public void set(Position position) {
        this.point.set(position.point);
        this.angle.set(position.angle);
    }

    public void set(Camera camera) {
        this.point.set(camera);
        this.angle.set(camera);
    }

    public void copy(Position position) {
        this.point.set(position.point.x, position.point.y, position.point.z);
        this.angle.set(position.angle.yaw, position.angle.pitch, position.angle.roll, position.angle.fov);
    }

    public void apply(Camera camera) {
        camera.position.set(this.point.x, this.point.y, this.point.z);
        camera.rotation.set(MathUtils.toRad(this.angle.pitch), MathUtils.toRad(this.angle.yaw), MathUtils.toRad(this.angle.roll));
        camera.fov = MathUtils.toRad(this.angle.fov);
    }

    public void interpolate(Position position, float factor) {
        this.point.x = Lerps.lerp(this.point.x, position.point.x, (double)factor);
        this.point.y = Lerps.lerp(this.point.y, position.point.y, (double)factor);
        this.point.z = Lerps.lerp(this.point.z, position.point.z, (double)factor);
        this.angle.yaw = Lerps.lerp(this.angle.yaw, position.angle.yaw, factor);
        this.angle.pitch = Lerps.lerp(this.angle.pitch, position.angle.pitch, factor);
        this.angle.roll = Lerps.lerp(this.angle.roll, position.angle.roll, factor);
        this.angle.fov = Lerps.lerp(this.angle.fov, position.angle.fov, factor);
    }

    public Position copy() {
        return new Position(this.point.copy(), this.angle.copy());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Position) {
            Position position = (Position)obj;
            return this.angle.equals(position.angle) && this.point.equals(position.point);
        }
        return super.equals(obj);
    }

    @Override
    public void toData(MapType data) {
        data.put("point", this.point.toData());
        data.put("angle", this.angle.toData());
    }

    @Override
    public void fromData(MapType data) {
        if (data.has("point", 0) && data.has("angle", 0)) {
            this.point.fromData(data.getMap("point"));
            this.angle.fromData(data.getMap("angle"));
        }
    }
}

