/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.values;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;

public class ValueChannels
extends ValueGroup {
    private List<KeyframeChannel<Double>> list = new ArrayList<KeyframeChannel<Double>>();

    public ValueChannels(String id) {
        super(id);
    }

    public KeyframeChannel<Double> addChannel(String s) {
        KeyframeChannel<Double> channel = new KeyframeChannel<Double>(s, KeyframeFactories.DOUBLE);
        this.preNotify();
        this.add(channel);
        this.postNotify();
        return channel;
    }

    public void removeChannel(KeyframeChannel channel) {
        BaseValue baseValue = this.get(channel.getId());
        if (baseValue == channel) {
            this.preNotify();
            this.remove(baseValue);
            this.postNotify();
        }
    }

    public List<KeyframeChannel<Double>> getChannels() {
        this.list.clear();
        for (BaseValue baseValue : this.getAll()) {
            KeyframeChannel channel;
            if (!(baseValue instanceof KeyframeChannel) || (channel = (KeyframeChannel)baseValue).getFactory() != KeyframeFactories.DOUBLE) continue;
            this.list.add(channel);
        }
        this.list.sort((a, b) -> a.getId().compareToIgnoreCase(b.getId()));
        return this.list;
    }

    @Override
    public void fromData(BaseType data) {
        this.removeAll();
        if (data.isMap()) {
            MapType map = data.asMap();
            HashSet<String> keys = new HashSet<String>(map.keys());
            for (String key : keys) {
                String newKey = key.replaceAll("/", ".");
                if (!newKey.equals(key)) {
                    map.put(newKey, map.get(key));
                    map.remove(key);
                }
                this.add(new KeyframeChannel<Double>(newKey, KeyframeFactories.DOUBLE));
            }
        }
        super.fromData(data);
    }
}

