/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.values;

import java.util.List;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.camera.values.ValuePosition;
import mchorse.bbs_mod.settings.values.core.ValueList;

public class ValuePositions
extends ValueList<ValuePosition> {
    public ValuePositions(String id) {
        super(id);
    }

    @Override
    public void add(Position position) {
        this.preNotify();
        this.add(new ValuePosition("", position));
        this.sync();
        this.postNotify();
    }

    @Override
    public void add(int index, Position position) {
        if (index >= this.list.size()) {
            this.add(position);
            return;
        }
        this.preNotify(1);
        this.list.add(index, new ValuePosition("", position));
        this.sync();
        this.postNotify(1);
    }

    public void move(int index, int to) {
        this.preNotify(1);
        this.list.add(index, (ValuePosition)this.list.remove(to));
        this.sync();
        this.postNotify(1);
    }

    public void remove(int index) {
        this.preNotify(1);
        this.list.remove(index);
        this.sync();
        this.postNotify(1);
    }

    public void set(List<Position> positions) {
        this.preNotify();
        this.list.clear();
        for (Position position : positions) {
            this.add(position.copy());
        }
        this.sync();
        this.postNotify();
    }

    public void reset() {
        this.preNotify();
        this.list.clear();
        this.postNotify();
    }

    public Position get(int index) {
        return ((ValuePosition)this.list.get(index)).get();
    }

    public int size() {
        return this.list.size();
    }

    @Override
    protected ValuePosition create(String id) {
        return new ValuePosition(id);
    }
}

