/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.model;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.cubic.MolangHelper;
import mchorse.bbs_mod.cubic.model.ModelLoader;
import mchorse.bbs_mod.cubic.model.loaders.BOBJModelLoader;
import mchorse.bbs_mod.cubic.model.loaders.CubicModelLoader;
import mchorse.bbs_mod.cubic.model.loaders.GeoCubicModelLoader;
import mchorse.bbs_mod.cubic.model.loaders.IModelLoader;
import mchorse.bbs_mod.cubic.model.loaders.VoxModelLoader;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.math.molang.MolangParser;
import mchorse.bbs_mod.resources.AssetProvider;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.IOUtils;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.pose.PoseManager;
import mchorse.bbs_mod.utils.pose.ShapeKeysManager;
import mchorse.bbs_mod.utils.watchdog.IWatchDogListener;
import mchorse.bbs_mod.utils.watchdog.WatchDogEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ModelManager
implements IWatchDogListener {
    public static final String MODELS_PREFIX = "models/";
    public final Map<String, ModelInstance> models = new HashMap<String, ModelInstance>();
    public final List<IModelLoader> loaders = new ArrayList<IModelLoader>();
    public final AssetProvider provider;
    public final MolangParser parser;
    private ModelLoader loader = new ModelLoader(this);

    public ModelManager(AssetProvider provider) {
        this.provider = provider;
        this.parser = new MolangParser();
        MolangHelper.registerVars(this.parser);
        this.loaders.add(new BOBJModelLoader());
        this.loaders.add(new CubicModelLoader());
        this.loaders.add(new GeoCubicModelLoader());
        this.loaders.add(new VoxModelLoader());
    }

    public List<String> getAvailableKeys() {
        ArrayList<Link> models = new ArrayList<Link>(BBSMod.getProvider().getLinksFromPath(Link.assets("models"), true));
        HashSet<String> keys = new HashSet<String>();
        models.sort((a, b) -> a.toString().compareToIgnoreCase(b.toString()));
        for (Link link : models) {
            int lastSlash;
            String path;
            int slash;
            if (!this.isRelodable(link) || (slash = (path = link.path).indexOf(47)) == (lastSlash = path.lastIndexOf(47))) continue;
            path = path.substring(slash + 1, lastSlash);
            keys.add(path);
        }
        return new ArrayList<String>(keys);
    }

    public ModelInstance getModel(String id) {
        if (this.models.containsKey(id)) {
            return this.models.get(id);
        }
        this.models.put(id, null);
        this.loader.add(id);
        return null;
    }

    public ModelInstance loadModel(String id) {
        IModelLoader loader;
        ModelInstance model = null;
        Link modelLink = Link.assets(MODELS_PREFIX + id);
        Collection<Link> links = this.provider.getLinksFromPath(modelLink, true);
        MapType config = this.loadConfig(modelLink);
        Iterator<IModelLoader> iterator = this.loaders.iterator();
        while (iterator.hasNext() && (model = (loader = iterator.next()).load(id, this, modelLink, links, config)) == null) {
        }
        if (model == null) {
            System.err.println("Model \"" + id + "\" wasn't loaded properly, or was loaded with no top level groups!");
        } else {
            System.out.println("Model \"" + id + "\" was loaded!");
            model.setup();
        }
        this.models.put(id, model);
        return model;
    }

    private MapType loadConfig(Link modelLink) {
        MapType mapType;
        block8: {
            InputStream asset = this.provider.getAsset(modelLink.combine("config.json"));
            try {
                String string = IOUtils.readText(asset);
                mapType = (MapType)DataToString.fromString(string);
                if (asset == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (asset != null) {
                        try {
                            asset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            asset.close();
        }
        return mapType;
    }

    public void reload() {
        for (ModelInstance model : this.models.values()) {
            if (model == null) continue;
            model.delete();
        }
        this.models.clear();
        PoseManager.INSTANCE.clear();
        ShapeKeysManager.INSTANCE.clear();
    }

    public boolean isRelodable(Link link) {
        if (!link.path.startsWith(MODELS_PREFIX)) {
            return false;
        }
        if (link.path.contains("/animations/") || link.path.contains("/shapes/")) {
            return false;
        }
        return link.path.endsWith(".bbs.json") || link.path.endsWith(".geo.json") || link.path.endsWith(".bobj") || link.path.endsWith(".obj") || link.path.endsWith(".animation.json") || link.path.endsWith(".vox") || link.path.endsWith("/config.json");
    }

    @Override
    public void accept(Path path, WatchDogEvent event) {
        String key;
        ModelInstance model;
        Link link = BBSMod.getProvider().getLink(path.toFile());
        if (link == null) {
            return;
        }
        if (this.isRelodable(link) && (model = this.models.remove(key = StringUtils.parentPath(link.path.substring(MODELS_PREFIX.length())))) != null) {
            model.delete();
        }
    }
}

