/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.model.loaders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.cubic.model.ModelManager;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.resources.Link;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public interface IModelLoader {
    public static Link getLink(Link link, Collection<Link> links, String suffix) {
        return IModelLoader.getLink(link, links, (Link l) -> l.path.endsWith(suffix));
    }

    public static Link getLink(Link link, Collection<Link> links, Predicate<Link> predicate) {
        if (!links.contains(link)) {
            for (Link l : links) {
                if (!predicate.test(l)) continue;
                return l;
            }
        }
        return link;
    }

    public static List<Link> getLinks(Collection<Link> links, String suffix) {
        return IModelLoader.getLinks(links, (Link l) -> l.path.endsWith(suffix));
    }

    public static List<Link> getLinks(Collection<Link> links, Predicate<Link> predicate) {
        ArrayList<Link> newLinks = new ArrayList<Link>();
        for (Link l : links) {
            if (!predicate.test(l)) continue;
            newLinks.add(l);
        }
        return newLinks;
    }

    public ModelInstance load(String var1, ModelManager var2, Link var3, Collection<Link> var4, MapType var5);
}

