/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.film;

import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mchorse.bbs_mod.camera.data.Point;
import mchorse.bbs_mod.client.renderer.ModelBlockEntityRenderer;
import mchorse.bbs_mod.entity.ActorEntity;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.FilmControllerContext;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.entities.MCEntity;
import mchorse.bbs_mod.forms.entities.StubEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.utils.Anchor;
import mchorse.bbs_mod.forms.renderers.FormRenderType;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.mixin.client.ClientPlayerEntityAccessor;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.joml.Matrices;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_765;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public abstract class BaseFilmController {
    public final Film film;
    protected IntObjectMap<IEntity> entities = new IntObjectHashMap();
    public boolean paused;
    public int exception = -1;

    public static void renderEntity(FilmControllerContext context) {
        boolean relative;
        IntObjectMap<IEntity> entities = context.entities;
        IEntity entity = context.entity;
        class_4184 camera = context.camera;
        class_4587 stack = context.stack;
        float transition = context.transition;
        Form form = entity.getForm();
        if (form == null) {
            return;
        }
        Vector3d position = Vectors.TEMP_3D.set(Lerps.lerp(entity.getPrevX(), entity.getX(), (double)transition), Lerps.lerp(entity.getPrevY(), entity.getY(), (double)transition), Lerps.lerp(entity.getPrevZ(), entity.getZ(), (double)transition));
        Anchor value = (Anchor)form.anchor.get();
        double cx = camera.method_19326().field_1352;
        double cy = camera.method_19326().field_1351;
        double cz = camera.method_19326().field_1350;
        boolean bl = relative = context.replay != null && context.relative;
        if (relative) {
            cx = context.replay.keyframes.x.interpolate(0.0f) + ((Point)context.replay.relativeOffset.get()).x;
            cy = context.replay.keyframes.y.interpolate(0.0f) + ((Point)context.replay.relativeOffset.get()).y;
            cz = context.replay.keyframes.z.interpolate(0.0f) + ((Point)context.replay.relativeOffset.get()).z;
        }
        Matrix4f target = null;
        Matrix4f defaultMatrix = BaseFilmController.getMatrixForRenderWithRotation(entity, cx, cy, cz, transition);
        float opacity = 1.0f;
        if (!relative) {
            boolean same;
            boolean bl2 = same = value.previousActor == -2 || value.actor == value.previousActor && Objects.equals(value.attachment, value.previousAttachment);
            if (same) {
                matrix = BaseFilmController.getEntityMatrix(entities, cx, cy, cz, value.actor, value.attachment, value.translate, value.scale, defaultMatrix, transition);
                if (matrix != defaultMatrix) {
                    target = matrix;
                    opacity = 0.0f;
                }
            } else if (value.x <= 0.0f && value.previousActor >= -1) {
                matrix = BaseFilmController.getEntityMatrix(entities, cx, cy, cz, value.previousActor, value.previousAttachment, value.previousTranslate, value.previousScale, defaultMatrix, transition);
                if (matrix != defaultMatrix) {
                    target = matrix;
                    opacity = 0.0f;
                }
            } else {
                Matrix4f lastMatrix;
                matrix = BaseFilmController.getEntityMatrix(entities, cx, cy, cz, value.actor, value.attachment, value.translate, value.scale, defaultMatrix, transition);
                if (matrix != (lastMatrix = BaseFilmController.getEntityMatrix(entities, cx, cy, cz, value.previousActor, value.previousAttachment, value.previousTranslate, value.previousScale, defaultMatrix, transition))) {
                    float factor = value.x;
                    Matrix4f matrix4f = target = factor >= 1.0f ? matrix : Matrices.lerp(lastMatrix, matrix, factor);
                    opacity = value.actor == -1 && value.previousActor >= 0 ? factor : (value.actor >= 0 && value.previousActor == -1 ? 1.0f - factor : 0.0f);
                }
            }
        }
        if (target != null) {
            Vector3f v = target.getTranslation(new Vector3f());
            Vector3f v2 = defaultMatrix.getTranslation(new Vector3f());
            position.x += (double)(v.x - v2.x);
            position.y += (double)(v.y - v2.y);
            position.z += (double)(v.z - v2.z);
        }
        class_2338 pos = class_2338.method_49637((double)position.x, (double)(position.y + 0.5), (double)position.z);
        int sky = entity.getWorld().method_8314(class_1944.field_9284, pos);
        int torch = entity.getWorld().method_8314(class_1944.field_9282, pos);
        int light = class_765.method_23687((int)torch, (int)sky);
        int overlay = class_4608.method_23625((int)class_4608.method_23210((float)0.0f), (int)class_4608.method_23212((entity.getHurtTimer() > 0 ? 1 : 0) != 0));
        FormRenderingContext formContext = new FormRenderingContext().set(FormRenderType.ENTITY, entity, stack, light, overlay, transition).camera(camera).stencilMap(context.map).color(context.color);
        stack.method_22903();
        if (relative) {
            stack.method_23760().method_23761().identity();
            stack.method_23760().method_23762().identity();
        }
        MatrixStackUtils.multiply(stack, target == null ? defaultMatrix : target);
        FormUtilsClient.render(form, formContext);
        if (context.bone != null && UIBaseMenu.renderAxes) {
            Form root = FormUtils.getRoot(form);
            class_4587 tempStack = new class_4587();
            HashMap<String, Matrix4f> map = new HashMap<String, Matrix4f>();
            FormUtilsClient.getRenderer(root).collectMatrices(entity, context.local ? null : context.bone, tempStack, map, "", transition);
            Matrix4f matrix = (Matrix4f)map.get(context.bone);
            if (matrix != null) {
                stack.method_22903();
                MatrixStackUtils.multiply(stack, matrix);
                Draw.coolerAxes(stack, 0.25f, 0.01f, 0.26f, 0.02f);
                RenderSystem.enableDepthTest();
                stack.method_22909();
            }
        }
        stack.method_22909();
        if (!relative && context.map == null && opacity > 0.0f && context.shadowRadius > 0.0f) {
            stack.method_22903();
            stack.method_22904(position.x - cx, position.y - cy, position.z - cz);
            ModelBlockEntityRenderer.renderShadow(context.consumers, stack, transition, position.x, position.y, position.z, 0.0f, 0.0f, 0.0f, context.shadowRadius, opacity);
            stack.method_22909();
        }
        if (!relative && !context.nameTag.isEmpty() && context.map == null) {
            stack.method_22903();
            stack.method_22904(position.x - cx, position.y - cy, position.z - cz);
            BaseFilmController.renderNameTag(entity, (class_2561)class_2561.method_43470((String)StringUtils.processColoredText(context.nameTag)), stack, context.consumers, light);
            stack.method_22909();
        }
        RenderSystem.enableDepthTest();
    }

    private static void renderNameTag(IEntity entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light) {
        boolean sneaking = !entity.isSneaking();
        float hitboxH = (float)entity.getPickingHitbox().h + 0.5f;
        matrices.method_22903();
        matrices.method_46416(0.0f, hitboxH, 0.0f);
        matrices.method_22907(class_310.method_1551().method_1561().method_24197());
        matrices.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        class_327 textRenderer = class_310.method_1551().field_1772;
        float opacity = class_310.method_1551().field_1690.method_19343(0.25f);
        int background = (int)(opacity * 255.0f) << 24;
        float h = -textRenderer.method_27525((class_5348)text) / 2;
        textRenderer.method_30882(text, h, 0.0f, 0x20FFFFFF, false, matrix4f, vertexConsumers, sneaking ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, background, light);
        if (sneaking) {
            textRenderer.method_30882(text, h, 0.0f, -1, false, matrix4f, vertexConsumers, class_327.class_6415.field_33993, 0, light);
        }
        matrices.method_22909();
    }

    public static Matrix4f getEntityMatrix(IntObjectMap<IEntity> entities, double cameraX, double cameraY, double cameraZ, int actor, String attachment, boolean translate, boolean scale, Matrix4f defaultMatrix, float transition) {
        IEntity entity = (IEntity)entities.get(actor);
        if (entity != null) {
            Matrix4f basic = new Matrix4f((Matrix4fc)BaseFilmController.getMatrixForRenderWithRotation(entity, cameraX, cameraY, cameraZ, transition));
            HashMap<String, Matrix4f> map = new HashMap<String, Matrix4f>();
            class_4587 stack = new class_4587();
            Form form = entity.getForm();
            if (form != null) {
                FormUtilsClient.getRenderer(form).collectMatrices(entity, null, stack, map, "", transition);
                Matrix4f matrix = (Matrix4f)map.get(attachment);
                if (matrix != null) {
                    basic.mul((Matrix4fc)matrix);
                    if (scale) {
                        Matrix3f mat = Matrices.TEMP_3F;
                        Vector3f vec = Vectors.TEMP_3F;
                        basic.get3x3(mat);
                        mat.getRow(0, vec);
                        vec.normalize();
                        mat.setRow(0, (Vector3fc)vec);
                        mat.getRow(1, vec);
                        vec.normalize();
                        mat.setRow(1, (Vector3fc)vec);
                        mat.getRow(2, vec);
                        vec.normalize();
                        mat.setRow(2, (Vector3fc)vec);
                        basic.set3x3((Matrix3fc)mat);
                    }
                    if (translate) {
                        basic.getTranslation(Vectors.TEMP_3F);
                        basic.set((Matrix3fc)Matrices.TEMP_3F.set((Matrix4fc)defaultMatrix));
                        basic.setTranslation((Vector3fc)Vectors.TEMP_3F);
                    }
                }
            }
            return basic;
        }
        return defaultMatrix;
    }

    public static Matrix4f getMatrixForRenderWithRotation(IEntity entity, double cameraX, double cameraY, double cameraZ, float tickDelta) {
        double x = Lerps.lerp(entity.getPrevX(), entity.getX(), (double)tickDelta) - cameraX;
        double y = Lerps.lerp(entity.getPrevY(), entity.getY(), (double)tickDelta) - cameraY;
        double z = Lerps.lerp(entity.getPrevZ(), entity.getZ(), (double)tickDelta) - cameraZ;
        Matrix4f matrix = new Matrix4f();
        float bodyYaw = Lerps.lerp(entity.getPrevBodyYaw(), entity.getBodyYaw(), tickDelta);
        matrix.translate((float)x, (float)y, (float)z);
        matrix.rotateY(MathUtils.toRad(-bodyYaw));
        return matrix;
    }

    public BaseFilmController(Film film) {
        this.film = film;
    }

    public IntObjectMap<IEntity> getEntities() {
        return this.entities;
    }

    public void togglePause() {
        this.paused = !this.paused;
    }

    public void createEntities() {
        this.entities.clear();
        if (this.film == null) {
            return;
        }
        int i = 0;
        for (Replay replay : this.film.replays.getList()) {
            if (((Boolean)replay.enabled.get()).booleanValue()) {
                class_638 world = class_310.method_1551().field_1687;
                StubEntity entity = new StubEntity((class_1937)world);
                entity.setForm(FormUtils.copy((Form)replay.form.get()));
                replay.applyFrame(0, entity);
                entity.setPrevX(entity.getX());
                entity.setPrevY(entity.getY());
                entity.setPrevZ(entity.getZ());
                entity.setPrevYaw(entity.getYaw());
                entity.setPrevHeadYaw(entity.getHeadYaw());
                entity.setPrevPitch(entity.getPitch());
                entity.setPrevBodyYaw(entity.getBodyYaw());
                this.entities.put(i, (Object)entity);
            }
            ++i;
        }
    }

    public abstract Map<String, Integer> getActors();

    public abstract int getTick();

    public boolean hasFinished() {
        return false;
    }

    public void update() {
        this.updateEntities(this.getTick());
    }

    protected void updateEntities(int ticks) {
        for (Map.Entry entry : this.entities.entrySet()) {
            Integer entityId;
            int i = (Integer)entry.getKey();
            IEntity entity = (IEntity)entry.getValue();
            List replays = this.film.replays.getList();
            Replay replay = (Replay)CollectionUtils.getSafe(replays, i);
            if (!this.canUpdate(i, replay, entity, UpdateMode.UPDATE) || replay == null) continue;
            ticks = replay.getTick(ticks);
            this.updateEntityAndForm(entity, ticks);
            this.applyReplay(replay, ticks, entity);
            Map<String, Integer> actors = this.getActors();
            if (actors == null || (entityId = actors.get(replay.getId())) == null) continue;
            class_1297 anEntity = class_310.method_1551().field_1687.method_8469(entityId.intValue());
            if (anEntity instanceof ActorEntity) {
                ActorEntity actor = (ActorEntity)anEntity;
                actor.method_36456(replay.keyframes.yaw.interpolate(ticks).floatValue());
                actor.method_5847(replay.keyframes.headYaw.interpolate(ticks).floatValue());
                actor.method_5636(replay.keyframes.bodyYaw.interpolate(ticks).floatValue());
                actor.method_36457(replay.keyframes.pitch.interpolate(ticks).floatValue());
                replay.applyClientActions(ticks, new MCEntity(anEntity), this.film);
                continue;
            }
            if (!(anEntity instanceof class_1657)) continue;
            class_1657 player = (class_1657)anEntity;
            double x = replay.keyframes.x.interpolate(ticks);
            double y = replay.keyframes.y.interpolate(ticks);
            double z = replay.keyframes.z.interpolate(ticks);
            double prevX = replay.keyframes.x.interpolate(ticks - 1);
            double prevY = replay.keyframes.y.interpolate(ticks - 1);
            double prevZ = replay.keyframes.z.interpolate(ticks - 1);
            player.method_18800(x - prevX, y - prevY, z - prevZ);
        }
    }

    public void updateEndWorld() {
        int ticks = this.getTick();
        for (Map.Entry entry : this.entities.entrySet()) {
            class_1297 anEntity;
            Integer entityId;
            int i = (Integer)entry.getKey();
            IEntity entity = (IEntity)entry.getValue();
            List replays = this.film.replays.getList();
            Replay replay = (Replay)CollectionUtils.getSafe(replays, i);
            if (!this.canUpdate(i, replay, entity, UpdateMode.UPDATE) || replay == null) continue;
            ticks = replay.getTick(ticks);
            Map<String, Integer> actors = this.getActors();
            if (actors == null || (entityId = actors.get(replay.getId())) == null || !((anEntity = class_310.method_1551().field_1687.method_8469(entityId.intValue())) instanceof class_1657)) continue;
            class_1657 player = (class_1657)anEntity;
            double x = replay.keyframes.x.interpolate(ticks);
            double y = replay.keyframes.y.interpolate(ticks);
            double z = replay.keyframes.z.interpolate(ticks);
            boolean sneaking = replay.keyframes.sneaking.interpolate(ticks) > 0.0;
            class_243 pos = player.method_19538();
            player.method_5784(class_1313.field_6308, new class_243(x - pos.field_1352, y - pos.field_1351, z - pos.field_1350));
            player.method_5814(x, y, z);
            player.method_5660(sneaking);
            player.method_24830(replay.keyframes.grounded.interpolate(ticks) > 0.0);
            if (player instanceof ClientPlayerEntityAccessor) {
                ClientPlayerEntityAccessor accessor = (ClientPlayerEntityAccessor)player;
                accessor.bbs$setIsSneakingPose(sneaking);
            }
            if (player instanceof class_746) {
                class_746 playerEntity = (class_746)player;
                playerEntity.field_3913.field_3903 = sneaking;
            }
            player.field_6017 = replay.keyframes.fall.interpolate(ticks).floatValue();
        }
    }

    protected void updateEntityAndForm(IEntity entity, int tick) {
        entity.update();
        if (entity.getForm() != null) {
            entity.getForm().update(entity);
        }
    }

    protected void applyReplay(Replay replay, int ticks, IEntity entity) {
        replay.applyFrame(ticks, entity, null);
        replay.applyClientActions(ticks, entity, this.film);
    }

    public void startRenderFrame(float transition) {
        for (Map.Entry entry : this.entities.entrySet()) {
            Integer entityId;
            int i = (Integer)entry.getKey();
            IEntity entity = (IEntity)entry.getValue();
            Replay replay = (Replay)this.film.replays.getList().get(i);
            if (!this.canUpdate(i, replay, entity, UpdateMode.PROPERTIES)) continue;
            float delta = this.getTransition(entity, transition);
            int tick = replay.getTick(this.getTick());
            replay.applyProperties((float)tick + delta, entity.getForm());
            Map<String, Integer> actors = this.getActors();
            if (actors == null || (entityId = actors.get(replay.getId())) == null) continue;
            class_1297 anEntity = class_310.method_1551().field_1687.method_8469(entityId.intValue());
            if (anEntity instanceof ActorEntity) {
                ActorEntity actor = (ActorEntity)anEntity;
                replay.applyProperties((float)tick + delta, actor.getForm());
                continue;
            }
            if (!(anEntity instanceof class_1657)) continue;
            class_1657 player = (class_1657)anEntity;
            Morph morph = Morph.getMorph((class_1297)player);
            if (morph != null) {
                replay.applyProperties((float)tick + delta, morph.getForm());
            }
            float yawHead = replay.keyframes.headYaw.interpolate((float)tick + delta).floatValue();
            float yawBody = replay.keyframes.bodyYaw.interpolate((float)tick + delta).floatValue();
            float pitch = replay.keyframes.pitch.interpolate((float)tick + delta).floatValue();
            player.method_36456(yawHead);
            player.method_5847(yawHead);
            player.method_36457(pitch);
            player.method_5636(yawBody);
            player.field_5982 = yawHead;
            player.field_6259 = yawHead;
            player.field_6004 = pitch;
            player.field_6220 = yawBody;
        }
    }

    protected float getTransition(IEntity entity, float transition) {
        return this.paused ? 0.0f : transition;
    }

    protected boolean canUpdate(int i, Replay replay, IEntity entity, UpdateMode updateMode) {
        if (this.paused && updateMode == UpdateMode.UPDATE) {
            return false;
        }
        return i != this.exception;
    }

    public void render(WorldRenderContext context) {
        RenderSystem.enableDepthTest();
        for (Map.Entry entry : this.entities.entrySet()) {
            int i = (Integer)entry.getKey();
            IEntity entity = (IEntity)entry.getValue();
            Replay replay = (Replay)this.film.replays.getList().get(i);
            if (!this.canUpdate(i, replay, entity, UpdateMode.RENDER)) continue;
            this.renderEntity(context, replay, entity);
        }
    }

    protected void renderEntity(WorldRenderContext context, Replay replay, IEntity entity) {
        if (!((Boolean)replay.actor.get()).booleanValue()) {
            FilmControllerContext filmContext = this.getFilmControllerContext(context, replay, entity);
            filmContext.transition = this.getTransition(entity, context.tickDelta());
            BaseFilmController.renderEntity(filmContext);
        }
    }

    protected FilmControllerContext getFilmControllerContext(WorldRenderContext context, Replay replay, IEntity entity) {
        return FilmControllerContext.instance.setup(this.entities, entity, replay, context).shadow((Boolean)replay.shadow.get(), ((Float)replay.shadowSize.get()).floatValue()).nameTag((String)replay.nameTag.get()).relative((Boolean)replay.relative.get());
    }

    public void shutdown() {
    }

    @Environment(value=EnvType.CLIENT)
    public static enum UpdateMode {
        UPDATE,
        RENDER,
        PROPERTIES;

    }
}

